<?php
/*
Fast Secure Contact Form
Mike Challis
http://www.642weather.com/weather/scripts.php
*/

  // the admin settings page

   if ( function_exists('current_user_can') && !current_user_can('manage_options') )
             die(__('You do not have permissions for managing this option', 'si-contact-form'));

 // multi-form ctf_form_num
  $form_num = $this->si_contact_form_num();

  if($form_num == '') {
        $form_id = 1;
  }else{
        $form_id = $form_num;
  }

  // get options
  $si_contact_gb = $this->si_contact_get_options($form_num);

  // a couple language options need to be translated now.
  $this->si_contact_update_lang();

    // action backup restore
	if (isset($_POST['ctf_action'])
    && $_POST['ctf_action'] == __('Restore Settings', 'si-contact-form')
    && isset($_POST['si_contact_backup_type'])) {
        check_admin_referer( 'si-contact-form-restore_settings'); // nonce

     echo $this->si_contact_form_backup_restore($_POST['si_contact_backup_type']);

     // refresh settings to initialize the restored backup
     $si_contact_gb = $this->si_contact_get_options($form_num);

  } // end action backup restore

	// Send a test mail if necessary
	if (isset($_POST['ctf_action']) && $_POST['ctf_action'] == __('Send Test', 'si-contact-form') && isset($_POST['si_contact_to'])) {
        check_admin_referer( 'si-contact-form-email_test'); // nonce

     // Set up the mail variables

     // new lines should be (\n for UNIX, \r\n for Windows and \r for Mac)
     //$php_eol = ( strtoupper(substr(PHP_OS,0,3) == 'WIN') ) ? "\r\n" : "\n";

	 $php_eol = (!defined('PHP_EOL')) ? (($eol = strtolower(substr(PHP_OS, 0, 3))) == 'win') ? "\r\n" : (($eol == 'mac') ? "\r" : "\n") : PHP_EOL;
	 $php_eol = (!$php_eol) ? "\n" : $php_eol;

	 $email = $_POST['si_contact_to'];
     $name = __('WordPress Contact Form Test', 'si-contact-form');
     if($this->ctf_validate_email($email)) {

		$subject = __('Test mail to ', 'si-contact-form') . $email;
		$message = __('This is a test mail generated by the Fast Secure Contact Form WordPress plugin.', 'si-contact-form').' '.$si_contact_opt['php_mailer_enable'];
        $message = wordwrap($message, 70,$php_eol);

    $smtp_debug = '';
    $header = '';
    $header_php = '';
    // prepare the email header
    $ctf_email_on_this_domain =  $si_contact_opt['email_from']; // optional
    if ($ctf_email_on_this_domain != '' ) {
         if(!preg_match("/,/", $ctf_email_on_this_domain)) {
           // just an email: user1@example.com
           $header_php =  "From: WordPress <$ctf_email_on_this_domain>\n";
           $this->si_contact_from_name = 'WordPress';
           $this->si_contact_mail_from = $ctf_email_on_this_domain;
         } else {
           // name and email: webmaster,user1@example.com
           list($key, $value) = explode(",",$ctf_email_on_this_domain);
           $key   = trim($key);
           $value = trim($value);
           $header_php =  "From: $key <$value>\n";
           $this->si_contact_from_name = $key;
           $this->si_contact_mail_from = $value;
         }
    } else if($email == '' || $name == '') {
         $header_php =  "From: WordPress <". get_option('admin_email') . ">\n";
         $this->si_contact_from_name = 'WordPress';
         $this->si_contact_mail_from = get_option('admin_email');
    } else {
         $header_php = "From: $name <$email>\n";;
         $this->si_contact_mail_from = $email;
         $this->si_contact_from_name = $name;
    }
    add_filter( 'wp_mail_from', array(&$this,'si_contact_form_mail_from'),1);
    add_filter( 'wp_mail_from_name', array(&$this,'si_contact_form_from_name'),1);

    $header .= "Reply-To: $this->si_contact_mail_from\n";
    $header .= "Return-Path: $this->si_contact_mail_from\n";
    $header .= 'Content-type: text/plain; charset='. get_option('blog_charset') . $php_eol;

    // http://www.knowledge-transfers.com/it/the-fifth-parameter-in-php-mail-function

    @ini_set('sendmail_from', $this->si_contact_mail_from);

    // Check for safe mode
    $this->safe_mode = ((boolean)@ini_get('safe_mode') === false) ? 0 : 1;

    if ($si_contact_opt['php_mailer_enable'] == 'php') {
       $header_php .= $header;
       // Start output buffering to grab smtp debugging output
	   ob_start();
      if ($ctf_email_on_this_domain != '' && !$this->safe_mode) {
          // the fifth parameter is not allowed in safe mode
          // Pass the Return-Path via sendmail's -f command.
        $result = mail($email,$subject,$message,$header_php, '-f '.$this->si_contact_mail_from);
      }else{
        $result = mail($email,$subject,$message,$header_php);
      }
      $smtp_debug = ob_get_clean();
    }else if ($si_contact_opt['php_mailer_enable'] == 'geekmail') {
         require_once WP_PLUGIN_DIR . '/si-contact-form/ctf_geekMail-1.0.php';
         $ctf_geekMail = new ctf_geekMail();
         $ctf_geekMail->setMailType('text');
         $ctf_geekMail->_setcharSet(get_option('blog_charset'));
         $ctf_geekMail->_setnewLine($php_eol);
         $ctf_geekMail->from($this->si_contact_mail_from, $this->si_contact_from_name);
         $ctf_geekMail->to($email);
         $ctf_geekMail->subject($subject);
         $ctf_geekMail->message($message);
         // Start output buffering to grab smtp debugging output
		 ob_start();
         if ( !$result = $ctf_geekMail->send() ) {
            $smtp_debug = ob_get_clean();
            $smtp_debug .= $ctf_geekMail->getDebugger();
         }

     }else if ($si_contact_opt['php_mailer_enable'] == 'wordpress') {

        global $phpmailer;
       	// Make sure the PHPMailer class has been instantiated
	    // (copied verbatim from wp-includes/pluggable.php)
	    // (Re)create it, if it's gone missing
	    if ( !is_object( $phpmailer ) || !is_a( $phpmailer, 'PHPMailer' ) ) {
		    require_once ABSPATH . WPINC . '/class-phpmailer.php';
		    require_once ABSPATH . WPINC . '/class-smtp.php';
		    $phpmailer = new PHPMailer();
	    }

		// Set SMTPDebug to level 2
		$phpmailer->SMTPDebug = 2;

		// Start output buffering to grab smtp debugging output
		ob_start();

		// Send the test mail
		$result = wp_mail($email,$subject,$message,$header);

		// Grab the smtp debugging output
		$smtp_debug = ob_get_clean();
      }

		// Output the response
		?>
<div id="message" class="updated fade"><p><strong><?php _e('Test Message Sent', 'si-contact-form'); echo '<br />'.$si_contact_opt['php_mailer_enable']; echo ' '.$subject; ?></strong></p>
<?php if ($result != true) { ?>
<p><?php _e('The result was:', 'si-contact-form'); ?></p>
<pre><?php var_dump($result); ?></pre>
<?php
if ($si_contact_opt['php_mailer_enable'] == 'wordpress') {
?>
<p><?php _e('The full debugging output is shown below:', 'si-contact-form'); ?></p>
<pre><?php var_dump($phpmailer); ?></pre>
<?php
    }
} else {
  echo '<p>'._e('Be sure to check your email to see if you received it.', 'si-contact-form').'</p>';
}
      if ($smtp_debug != '') {
?>
<p><?php _e('The E-mail debugging output is shown below:', 'si-contact-form'); ?></p>
<pre><?php echo $smtp_debug ?></pre>
<?php }

   }else{
     echo '<div id="message" class="updated fade"><p><strong>'.__('Test failed: Invalid E-mail address', 'si-contact-form').'</strong></p>';
   }
?>
</div>
<?php

	} // end Send a test mail if necessary


 // preview forms, viewable to logged in admin only
 if ( isset($_GET['show_form']) && is_numeric($_GET['show_form']) && !isset($_POST['ctf_action']) ) {

  $form = $_GET['show_form'];
  $form_num = '';
  $form_id = 1;
  if ( isset($form) && is_numeric($form) && $form <= $si_contact_gb['max_forms'] ) {
     $form_num = (int)$form;
     $form_id = (int)$form;
     if ($form_num == 1)
        $form_num = '';
  }

   // show form number links
   ?>

  <div class="wrap">
   <div id="main">
   <h2><?php _e('Fast Secure Contact Form', 'si-contact-form'); ?></h2>

   <h3><?php _e('Usage', 'si-contact-form'); ?></h3>


<p>
<?php _e('You must add the shortcode in a Page(not a post). That page will become your Contact Form', 'si-contact-form'); ?>. <a href="<?php echo WP_PLUGIN_URL; ?>/si-contact-form/screenshot-4.gif" target="_new"><?php _e('help', 'si-contact-form'); ?></a>
<br />
<?php _e('Shortcode for this form:', 'si-contact-form'); echo " [si-contact-form form='$form_id']"; ?>
</p>


<h3><?php _e('Preview', 'si-contact-form'); ?></h3>

   <div class="form-tab"><?php echo __('Preview Multi-Forms:', 'si-contact-form').' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id); ?></div>
   <div class="clear"></div>
   <fieldset>
   <h3><?php
  // multi-form selector
  for ($i = 1; $i <= $si_contact_gb['max_forms']; $i++) {
     if($i == 1) {
         if ($form_id == 1) {
             echo '<b>'.sprintf(__('Form: %d', 'si-contact-form'),1).'</b>';
             echo ' <small><a href="' . admin_url(  "plugins.php?page=si-contact-form/si-contact-form.php" ) . '">('. __('edit', 'si-contact-form'). ')</a></small>';
        } else {
             echo '<a href="' . admin_url(  'plugins.php?show_form='.$i.'&amp;page=si-contact-form/si-contact-form.php' ) . '">'. sprintf(__('Form: %d', 'si-contact-form'),1). '</a>';
        }
     } else {
        if ($form_id == $i) {
             echo ' | <b>' . sprintf(__('Form: %d', 'si-contact-form'),$i).'</b>';
             echo ' <small><a href="' . admin_url(  'plugins.php?ctf_form_num='.$i.'&amp;page=si-contact-form/si-contact-form.php' ) . '">('. __('edit', 'si-contact-form'). ')</a></small>';
        } else {
             echo ' | <a href="' . admin_url(  'plugins.php?show_form='.$i.'&amp;ctf_form_num='.$i.'&amp;page=si-contact-form/si-contact-form.php' ) . '">'. sprintf(__('Form: %d', 'si-contact-form'),$i). '</a>';
        }
     }
  }
  ?>
  </h3>

  <br />

  <?php
   echo $this->si_contact_form_short_code( array( 'form' => "$form" ) );

  echo '
  </fieldset>
  </div>
  </div>
  ';
 }// end preview forms


  if (isset($_POST['submit']) && !isset($_POST['ctf_action'])) {
     check_admin_referer( 'si-contact-form-options_update'); // nonce
   // post changes to the options array
   $optionarray_gb_update = array(
         'donated' =>          (isset( $_POST['si_contact_donated'] ) ) ? 'true' : 'false',
         'max_forms' =>    ( is_numeric(trim($_POST['si_contact_max_forms'])) && trim($_POST['si_contact_max_forms']) < 100 ) ? absint(trim($_POST['si_contact_max_forms'])) : $si_contact_gb_defaults['max_forms'],
         'max_fields' =>   ( is_numeric(trim($_POST['si_contact_max_fields'])) && trim($_POST['si_contact_max_fields']) < 100 ) ? absint(trim($_POST['si_contact_max_fields'])) : $si_contact_gb_defaults['max_fields'],
         'captcha_disable_session' =>   (isset( $_POST['si_contact_captcha_disable_session'] ) ) ? 'true' : 'false',
         'adv_opt_enable'         =>    (isset( $_POST['si_contact_adv_opt_enable'] ) ) ? 'true' : 'false',
         );

   if(isset($si_contact_gb['2.6.3'] ))
                 $optionarray_gb_update['2.6.3'] = $si_contact_gb['2.6.3'];

   $optionarray_update = array(
         'welcome' =>             trim($_POST['si_contact_welcome']),  // can be empty
         'email_to' =>          ( trim($_POST['si_contact_email_to']) != '' ) ? trim($_POST['si_contact_email_to']) : $si_contact_option_defaults['email_to'], // use default if empty
         'php_mailer_enable' =>        $_POST['si_contact_php_mailer_enable'],
         'email_from' =>          trim($_POST['si_contact_email_from']),
         'email_bcc' =>           trim($_POST['si_contact_email_bcc']),
         'email_subject' =>     ( trim($_POST['si_contact_email_subject']) != '' ) ? trim($_POST['si_contact_email_subject']) : '',
         'email_subject_list' =>  trim($_POST['si_contact_email_subject_list']),
         'name_format' =>           $_POST['si_contact_name_format'],
         'name_type' =>             $_POST['si_contact_name_type'],
         'email_type' =>            $_POST['si_contact_email_type'],
         'subject_type' =>          $_POST['si_contact_subject_type'],
         'message_type' =>          $_POST['si_contact_message_type'],
         'double_email' =>     (isset( $_POST['si_contact_double_email'] ) ) ? 'true' : 'false', // true or false
         'name_case_enable' => (isset( $_POST['si_contact_name_case_enable'] ) ) ? 'true' : 'false',
         'sender_info_enable' =>   (isset( $_POST['si_contact_sender_info_enable'] ) ) ? 'true' : 'false',
         'domain_protect' =>   (isset( $_POST['si_contact_domain_protect'] ) ) ? 'true' : 'false',
         'email_check_dns' =>  (isset( $_POST['si_contact_email_check_dns'] ) ) ? 'true' : 'false',
         'akismet_disable' =>  (isset( $_POST['si_contact_akismet_disable'] ) ) ? 'true' : 'false',
         'akismet_send_anyway' =>  $_POST['si_contact_akismet_send_anyway'],
         'captcha_enable' =>   (isset( $_POST['si_contact_captcha_enable'] ) ) ? 'true' : 'false',
         'captcha_difficulty' =>  $_POST['si_contact_captcha_difficulty'],
         'captcha_small' =>     (isset( $_POST['si_contact_captcha_small'] ) ) ? 'true' : 'false',
         'captcha_no_trans' =>    (isset( $_POST['si_contact_captcha_no_trans'] ) ) ? 'true' : 'false',
         'enable_audio' =>        (isset( $_POST['si_contact_enable_audio'] ) ) ? 'true' : 'false',
         'enable_audio_flash' => (isset( $_POST['si_contact_enable_audio_flash'] ) ) ? 'true' : 'false',
         'captcha_perm' =>     (isset( $_POST['si_contact_captcha_perm'] ) ) ? 'true' : 'false',
         'captcha_perm_level' =>       $_POST['si_contact_captcha_perm_level'],
         'redirect_enable' =>  (isset( $_POST['si_contact_redirect_enable'] ) ) ? 'true' : 'false',
         'redirect_seconds' => ( is_numeric(trim($_POST['si_contact_redirect_seconds'])) && trim($_POST['si_contact_redirect_seconds']) < 61 ) ? absint(trim($_POST['si_contact_redirect_seconds'])) : $si_contact_option_defaults['redirect_seconds'],
         'redirect_url' =>        trim($_POST['si_contact_redirect_url']),
         'border_enable' =>    (isset( $_POST['si_contact_border_enable'] ) ) ? 'true' : 'false',
         'ex_fields_after_msg' => (isset( $_POST['si_contact_ex_fields_after_msg'] ) ) ? 'true' : 'false',
         'date_format' =>               $_POST['si_contact_date_format'],
         'cal_start_day' =>     ( preg_match('/^[0-6]?$/',$_POST['si_contact_cal_start_day']) ) ? trim($_POST['si_contact_cal_start_day']) : $si_contact_option_defaults['cal_start_day'],
         'attach_types' =>      trim(str_replace('.','',$_POST['si_contact_attach_types'])),
         'attach_size' =>       ( preg_match('/^([[0-9.]+)([kKmM]?[bB])?$/',$_POST['si_contact_attach_size']) ) ? trim($_POST['si_contact_attach_size']) : $si_contact_option_defaults['attach_size'],
         'textarea_html_allow' =>    (isset( $_POST['si_contact_textarea_html_allow'] ) ) ? 'true' : 'false',
         'auto_respond_enable' =>    (isset( $_POST['si_contact_auto_respond_enable'] ) ) ? 'true' : 'false',
         'auto_respond_html' =>      (isset( $_POST['si_contact_auto_respond_html'] ) ) ? 'true' : 'false',
         'auto_respond_from_name' => ( trim($_POST['si_contact_auto_respond_from_name']) != '' ) ? trim($_POST['si_contact_auto_respond_from_name']) : $si_contact_option_defaults['auto_respond_from_name'], // use default if empty
         'auto_respond_reply_to' =>  ( trim($_POST['si_contact_auto_respond_reply_to']) != '' && $this->ctf_validate_email($_POST['si_contact_auto_respond_reply_to'])) ? trim($_POST['si_contact_auto_respond_reply_to']) : $si_contact_option_defaults['auto_respond_reply_to'], // use default if empty
         'auto_respond_message' => trim($_POST['si_contact_auto_respond_message']),  // can be empty
         'auto_respond_subject' => trim($_POST['si_contact_auto_respond_subject']),  // can be empty
         'req_field_indicator' =>       $_POST['si_contact_req_field_indicator'],
         'req_field_label_enable' =>    (isset( $_POST['si_contact_req_field_label_enable'] ) ) ? 'true' : 'false',
         'req_field_indicator_enable' =>    (isset( $_POST['si_contact_req_field_indicator_enable'] ) ) ? 'true' : 'false',
         'form_style' =>          ( trim($_POST['si_contact_form_style']) != '' ) ? trim($_POST['si_contact_form_style']) : $si_contact_option_defaults['form_style'],
         'border_style' =>          ( trim($_POST['si_contact_border_style']) != '' ) ? trim($_POST['si_contact_border_style']) : $si_contact_option_defaults['border_style'],
         'required_style' =>      ( trim($_POST['si_contact_required_style']) != '' ) ? trim($_POST['si_contact_required_style']) : $si_contact_option_defaults['required_style'],
         'title_style' =>         ( trim($_POST['si_contact_title_style']) != '' ) ? trim($_POST['si_contact_title_style']) : $si_contact_option_defaults['title_style'],
         'select_style' =>        ( trim($_POST['si_contact_select_style']) != '' ) ? trim($_POST['si_contact_select_style']) : $si_contact_option_defaults['select_style'],
         'field_style' =>         ( trim($_POST['si_contact_field_style']) != '' ) ? trim($_POST['si_contact_field_style']) : $si_contact_option_defaults['field_style'],
         'field_div_style' =>     ( trim($_POST['si_contact_field_div_style']) != '' ) ? trim($_POST['si_contact_field_div_style']) : $si_contact_option_defaults['field_div_style'],
         'error_style' =>         ( trim($_POST['si_contact_error_style']) != '' ) ? trim($_POST['si_contact_error_style']) : $si_contact_option_defaults['error_style'],
         'captcha_div_style_sm' =>   ( trim($_POST['si_contact_captcha_div_style_sm']) != '' ) ? trim($_POST['si_contact_captcha_div_style_sm']) : $si_contact_option_defaults['captcha_div_style_sm'],
         'captcha_div_style_m' =>   ( trim($_POST['si_contact_captcha_div_style_m']) != '' ) ? trim($_POST['si_contact_captcha_div_style_m']) : $si_contact_option_defaults['captcha_div_style_m'],
         'submit_div_style' =>        ( trim($_POST['si_contact_submit_div_style']) != '' ) ? trim($_POST['si_contact_submit_div_style']) : $si_contact_option_defaults['submit_div_style'],
         'button_style' =>        ( trim($_POST['si_contact_button_style']) != '' ) ? trim($_POST['si_contact_button_style']) : $si_contact_option_defaults['button_style'],
         'powered_by_style' =>    ( trim($_POST['si_contact_powered_by_style']) != '' ) ? trim($_POST['si_contact_powered_by_style']) : $si_contact_option_defaults['powered_by_style'],
         'field_size' => ( is_numeric(trim($_POST['si_contact_field_size'])) && trim($_POST['si_contact_field_size']) > 14 ) ? absint(trim($_POST['si_contact_field_size'])) : $si_contact_option_defaults['field_size'], // use default if empty
         'captcha_field_size' => ( is_numeric(trim($_POST['si_contact_captcha_field_size'])) && trim($_POST['si_contact_captcha_field_size']) > 4 ) ? absint(trim($_POST['si_contact_captcha_field_size'])) : $si_contact_option_defaults['captcha_field_size'],
         'text_cols' =>    absint(trim($_POST['si_contact_text_cols'])),
         'text_rows' =>    absint(trim($_POST['si_contact_text_rows'])),
         'aria_required' =>    (isset( $_POST['si_contact_aria_required'] ) ) ? 'true' : 'false',
         'auto_fill_enable' => (isset( $_POST['si_contact_auto_fill_enable'] ) ) ? 'true' : 'false',
         'title_border' =>        trim($_POST['si_contact_title_border']),
         'title_dept' =>          trim($_POST['si_contact_title_dept']),
         'title_select' =>        trim($_POST['si_contact_title_select']),
         'title_name' =>          trim($_POST['si_contact_title_name']),
         'title_email' =>         trim($_POST['si_contact_title_email']),
         'title_email2' =>        trim($_POST['si_contact_title_email2']),
         'title_email2_help' =>   trim($_POST['si_contact_title_email2_help']),
         'title_subj' =>          trim($_POST['si_contact_title_subj']),
         'title_mess' =>          trim($_POST['si_contact_title_mess']),
         'title_capt' =>          trim($_POST['si_contact_title_capt']),
         'title_submit' =>        trim($_POST['si_contact_title_submit']),
         'text_message_sent' =>   trim($_POST['si_contact_text_message_sent']),
         'tooltip_required' =>    trim($_POST['si_contact_tooltip_required']),
         'tooltip_captcha' =>     trim($_POST['si_contact_tooltip_captcha']),
         'tooltip_audio' =>       trim($_POST['si_contact_tooltip_audio']),
         'tooltip_refresh' =>     trim($_POST['si_contact_tooltip_refresh']),
         'enable_credit_link' => (isset( $_POST['si_contact_enable_credit_link'] ) ) ? 'true' : 'false',
         'error_contact_select' => trim($_POST['si_contact_error_contact_select']),
         'error_name'           => trim($_POST['si_contact_error_name']),
         'error_email'          => trim($_POST['si_contact_error_email']),
         'error_email2'         => trim($_POST['si_contact_error_email2']),
         'error_field'          => trim($_POST['si_contact_error_field']),
         'error_subject'        => trim($_POST['si_contact_error_subject']),
         'error_message'        => trim($_POST['si_contact_error_message']),
         'error_input'          => trim($_POST['si_contact_error_input']),
         'error_captcha_blank'  => trim($_POST['si_contact_error_captcha_blank']),
         'error_captcha_wrong'  => trim($_POST['si_contact_error_captcha_wrong']),
         'error_correct'        => trim($_POST['si_contact_error_correct']),
  );

    // optional extra fields
    for ($i = 1; $i <= $optionarray_gb_update['max_fields']; $i++) {
        $optionarray_update['ex_field'.$i.'_label'] = (isset($_POST['si_contact_ex_field'.$i.'_label'])) ? trim($_POST['si_contact_ex_field'.$i.'_label']) : '';
        $optionarray_update['ex_field'.$i.'_type'] = (isset($_POST['si_contact_ex_field'.$i.'_type'])) ? trim($_POST['si_contact_ex_field'.$i.'_type']) : 'text';
        $optionarray_update['ex_field'.$i.'_default'] = ( isset($_POST['si_contact_ex_field'.$i.'_default']) && is_numeric(trim($_POST['si_contact_ex_field'.$i.'_default'])) && trim($_POST['si_contact_ex_field'.$i.'_default']) >= 0 ) ? absint(trim($_POST['si_contact_ex_field'.$i.'_default'])) : '0'; // use default if empty
        $optionarray_update['ex_field'.$i.'_req'] = (isset( $_POST['si_contact_ex_field'.$i.'_req'] ) ) ? 'true' : 'false';
        $optionarray_update['ex_field'.$i.'_notes'] = (isset($_POST['si_contact_ex_field'.$i.'_notes'])) ? trim($_POST['si_contact_ex_field'.$i.'_notes']) : '';
        if ($optionarray_update['ex_field'.$i.'_label'] != '' && !in_array($optionarray_update['ex_field'.$i.'_type'], array('checkbox','radio','select'))) {
                $optionarray_update['ex_field'.$i.'_default'] = '0';
        }
        if ($optionarray_update['ex_field'.$i.'_label'] == '' && $optionarray_update['ex_field'.$i.'_type'] != 'fieldset-close') {
          $optionarray_update['ex_field'.$i.'_type'] = 'text';
          $optionarray_update['ex_field'.$i.'_default'] = '0';
          $optionarray_update['ex_field'.$i.'_req'] = 'false';
          $optionarray_update['ex_field'.$i.'_notes'] = '';
        }
    }

    // deal with quotes
    foreach($optionarray_update as $key => $val) {
           $optionarray_update[$key] = str_replace('&quot;','"',trim($val));
    }

    if (isset($_POST['si_contact_reset_styles'])) {
         // reset styles feature
         $style_resets_arr = array('border_enable','form_style','border_style','required_style','title_style','field_style','field_div_style','error_style','select_style','captcha_div_style_sm','captcha_div_style_m','submit_div_style','button_style','powered_by_style','field_size','captcha_field_size','text_cols','text_rows');
         foreach($style_resets_arr as $style_reset) {
           $optionarray_update[$style_reset] = $si_contact_option_defaults[$style_reset];
         }
    }

    // save updated options to the database
    update_option("si_contact_form$form_num", $optionarray_update);

    // get the options from the database
    $si_contact_opt = get_option("si_contact_form$form_num");

    // save updated global options to the database
    update_option("si_contact_form_gb", $optionarray_gb_update);

    $redirect_to_form_1 = 0;
    if ( $optionarray_gb_update['max_forms'] != $si_contact_gb['max_forms'] ) {
       if ($optionarray_gb_update['max_forms'] < $si_contact_gb['max_forms']) {
         // delete all multi-forms higher than set number
         for ($i = $optionarray_gb_update['max_forms'] + 1; $i <= 100; $i++) {
            delete_option("si_contact_form$i");
         }
       }
      // max_forms settings has changed, need to redirect to form 1 later on
      $redirect_to_form_1 = 1;
    }

    // get the global options from the database
    $si_contact_gb = get_option("si_contact_form_gb");

    // strip slashes on get options array
    foreach($si_contact_opt as $key => $val) {
           $si_contact_opt[$key] = $this->ctf_stripslashes($val);
    }

    if (function_exists('wp_cache_flush')) {
	     wp_cache_flush();
	}

    if ($redirect_to_form_1) {
       // max_forms settings has changed, need to redirect to form 1
       $ctf_redirect_url = admin_url(  "plugins.php?page=si-contact-form/si-contact-form.php" );
       $ctf_redirect_timeout = 1;
 echo <<<EOT

<script type="text/javascript" language="javascript">
<!--
var count=$ctf_redirect_timeout;
var time;
function timedCount() {
  document.title='Redirecting in ' + count + ' seconds';
  count=count-1;
  time=setTimeout("timedCount()",1000);
  if (count==-1) {
    clearTimeout(time);
    document.title='Redirecting ...';
    self.location='$ctf_redirect_url';
  }
}
window.onload=timedCount;
//-->
</script>
EOT;

echo '
<div id="message" class="updated fade"><p><strong>
<img src="'.WP_PLUGIN_URL .'/si-contact-form/ctf-loading.gif" alt="'.esc_attr(__('Redirecting to Form 1', 'si-contact-form')).'" />&nbsp;&nbsp;
'.__('Redirecting to Form 1', 'si-contact-form').' ...
</strong></p></div>
';

    }


  } // end if (isset($_POST['submit']))


if ( !isset($_GET['show_form']) && !isset($_POST['fsc_action']) ) {

  // update translation for this setting (when switched from English to something else)
  if ($si_contact_opt['welcome'] == '<p>Comments or questions are welcome.</p>') {
       $si_contact_opt['welcome'] = __('<p>Comments or questions are welcome.</p>', 'si-contact-form');
  }

?>
<?php if ( !empty($_POST )  && !isset($_POST['ctf_action'])) : ?>
<div id="message" class="updated fade"><p><strong><?php _e('Options saved.', 'si-contact-form'); ?></strong></p></div>
<?php endif; ?>

<div class="wrap">
 <div id="main">

<h2><?php _e('Fast Secure Contact Form Options', 'si-contact-form'); ?></h2>

<script type="text/javascript">
    function toggleVisibility(id) {
       var e = document.getElementById(id);
       if(e.style.display == 'block')
          e.style.display = 'none';
       else
          e.style.display = 'block';
    }
</script>

<p>
<a href="http://wordpress.org/extend/plugins/si-contact-form/changelog/" target="_blank"><?php _e('Changelog', 'si-contact-form'); ?></a> |
<a href="http://www.fastsecurecontactform.com/faq-wordpress-version" target="_blank"><?php _e('FAQ', 'si-contact-form'); ?></a> |
<a href="http://wordpress.org/extend/plugins/si-contact-form/" target="_blank"><?php _e('Rate This', 'si-contact-form'); ?></a> |
<a href="http://www.fastsecurecontactform.com/support" target="_blank"><?php _e('Support', 'si-contact-form'); ?></a> |
<a href="http://www.fastsecurecontactform.com/donate" target="_blank"><?php _e('Donate', 'si-contact-form'); ?></a> |
<a href="http://www.642weather.com/weather/scripts.php" target="_blank"><?php _e('Free PHP Scripts', 'si-contact-form'); ?></a> |
<a href="http://www.fastsecurecontactform.com/contact" target="_blank"><?php _e('Contact', 'si-contact-form'); ?> Mike Challis</a>
</p>

<?php
if (function_exists('get_transient')) {
  require_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );

  // First, try to access the data, check the cache.
  if (false === ($api = get_transient('si_contact_form_info'))) {
    // The cache data doesn't exist or it's expired.

    $api = plugins_api('plugin_information', array('slug' => stripslashes( 'si-contact-form' ) ));

    if ( !is_wp_error($api) ) {
      // cache isn't up to date, write this fresh information to it now to avoid the query for xx time.
      $myexpire = 60 * 15; // Cache data for 15 minutes
      set_transient('si_contact_form_info', $api, $myexpire);
    }
  }
  if ( !is_wp_error($api) ) {
	  $plugins_allowedtags = array('a' => array('href' => array(), 'title' => array(), 'target' => array()),
								'abbr' => array('title' => array()), 'acronym' => array('title' => array()),
								'code' => array(), 'pre' => array(), 'em' => array(), 'strong' => array(),
								'div' => array(), 'p' => array(), 'ul' => array(), 'ol' => array(), 'li' => array(),
								'h1' => array(), 'h2' => array(), 'h3' => array(), 'h4' => array(), 'h5' => array(), 'h6' => array(),
								'img' => array('src' => array(), 'class' => array(), 'alt' => array()));
	  //Sanitize HTML
	  foreach ( (array)$api->sections as $section_name => $content )
		$api->sections[$section_name] = wp_kses($content, $plugins_allowedtags);
	  foreach ( array('version', 'author', 'requires', 'tested', 'homepage', 'downloaded', 'slug') as $key )
		$api->$key = wp_kses($api->$key, $plugins_allowedtags);

      if ( ! empty($api->downloaded) ) {
        echo sprintf(__('Downloaded %s times', 'si-contact-form'),number_format_i18n($api->downloaded));
        echo '.';
      }
?>
      <?php if ( ! empty($api->rating) ) : ?>
	  <div class="star-holder" title="<?php echo esc_attr(sprintf(__('(Average rating based on %s ratings)', 'si-contact-form'),number_format_i18n($api->num_ratings))); ?>">
	  <div class="star star-rating" style="width: <?php echo esc_attr($api->rating) ?>px"></div>
	  <div class="star star5"><img src="<?php echo admin_url('images/star.gif'); ?>" alt="<?php _e('5 stars', 'si-contact-form') ?>" /></div>
	  <div class="star star4"><img src="<?php echo admin_url('images/star.gif'); ?>" alt="<?php _e('4 stars', 'si-contact-form') ?>" /></div>
	  <div class="star star3"><img src="<?php echo admin_url('images/star.gif'); ?>" alt="<?php _e('3 stars', 'si-contact-form') ?>" /></div>
	  <div class="star star2"><img src="<?php echo admin_url('images/star.gif'); ?>" alt="<?php _e('2 stars', 'si-contact-form') ?>" /></div>
	  <div class="star star1"><img src="<?php echo admin_url('images/star.gif'); ?>" alt="<?php _e('1 star', 'si-contact-form') ?>" /></div>
	  </div>
	  <small><?php echo sprintf(__('(Average rating based on %s ratings)', 'si-contact-form'),number_format_i18n($api->num_ratings)); ?> <a target="_blank" href="http://wordpress.org/extend/plugins/<?php echo $api->slug ?>/"> <?php _e('rate', 'si-contact-form') ?></a></small>
	  <?php endif;
}// end if (function_exists('get_transient'
  } // if ( !is_wp_error($api)

if ($si_contact_gb['donated'] != 'true') {
?>
<h3><?php _e('Donate', 'si-contact-form'); ?></h3>

<form action="https://www.paypal.com/cgi-bin/webscr" method="post">

<table style="background-color:#FFE991; border:none; margin: -5px 0;" width="600">
        <tr>
        <td>
<input type="hidden" name="cmd" value="_s-xclick" />
<input type="hidden" name="hosted_button_id" value="8086141" />
<input type="image" src="https://www.paypal.com/en_US/i/btn/x-click-but04.gif" style="border:none;" name="submit" alt="Paypal Donate" />
<img alt="" style="border:none;" src="https://www.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1" />
</td>
<td>
<?php
_e('Please donate to keep this plugin FREE', 'si-contact-form'); echo '<br />';
_e('If you find this plugin useful to you, please consider making a small donation to help contribute to my time invested and to further development. Thanks for your kind support!', 'si-contact-form'); echo ' '; ?>
- <a style="cursor:pointer;" title="<?php _e('More from Mike Challis', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_mike_challis_tip');"><?php _e('More from Mike Challis', 'si-contact-form'); ?></a></td>
</tr></table>
</form>
<br />

<div style="text-align:left; display:none" id="si_contact_mike_challis_tip">
<img src="<?php echo WP_PLUGIN_URL; ?>/si-contact-form/si-contact-form.jpg" width="250" height="185" alt="Mike Challis" /><br />
<?php _e('Mike Challis says: "Hello, I have spent hundreds of hours coding this plugin just for you. If you are satisfied with my programs and support please consider making a small donation. If you are not able to, that is OK.', 'si-contact-form'); ?>
<?php echo ' '; _e('Most people donate $3, $5, $10, $20, or more. Though no amount is too small. Donations can be made with your PayPal account, or securely using any of the major credit cards. Please also rate my plugin."', 'si-contact-form'); ?>
 <a href="http://wordpress.org/extend/plugins/si-contact-form/" target="_blank"><?php _e('Rate This', 'si-contact-form'); ?></a>.
<br />
<a style="cursor:pointer;" title="Close" onclick="toggleVisibility('si_contact_mike_challis_tip');"><?php _e('Close this message', 'si-contact-form'); ?></a>
</div>

<?php
}
?>
<form name="formoptions" action="<?php echo admin_url( "plugins.php?ctf_form_num=$form_num&amp;page=si-contact-form/si-contact-form.php" ); ?>" method="post">
        <input type="hidden" name="action" value="update" />
        <input type="hidden" name="form_type" value="upload_options" />
        <?php wp_nonce_field('si-contact-form-options_update'); ?>

    <input name="si_contact_donated" id="si_contact_donated" type="checkbox" <?php if( $si_contact_gb['donated'] == 'true' ) echo 'checked="checked"'; ?> />
    <label for="si_contact_donated"><?php _e('I have donated to help contribute for the development of this Contact Form.', 'si-contact-form'); ?></label>
    <br />

<h3><?php _e('Usage', 'si-contact-form'); ?></h3>


<p>
<?php _e('You must add the shortcode in a Page(not a post). That page will become your Contact Form', 'si-contact-form'); ?>. <a href="<?php echo WP_PLUGIN_URL; ?>/si-contact-form/screenshot-4.gif" target="_new"><?php _e('help', 'si-contact-form'); ?></a>
<br />
<?php _e('Shortcode for this form:', 'si-contact-form'); echo " [si-contact-form form='$form_id']"; ?>
</p>


<h3><?php _e('Options', 'si-contact-form'); ?></h3>

<div class="form-tab"><?php echo __('Multi-forms:', 'si-contact-form').' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

<h3><?php
  // multi-form selector
  for ($i = 1; $i <= $si_contact_gb['max_forms']; $i++) {
     if($i == 1) {
         if ($form_id == 1) {
             echo '<b>'.sprintf(__('Form: %d', 'si-contact-form'),1).'</b>';
             echo ' <small><a href="' . admin_url(  "plugins.php?show_form=1&amp;page=si-contact-form/si-contact-form.php" ) . '">('. __('view', 'si-contact-form'). ')</a></small>';
        } else {
             echo '<a href="' . admin_url(  'plugins.php?page=si-contact-form/si-contact-form.php' ) . '">'. sprintf(__('Form: %d', 'si-contact-form'),1). '</a>';
        }
     } else {
        if ($form_id == $i) {
             echo ' | <b>' . sprintf(__('Form: %d', 'si-contact-form'),$i).'</b>';
             echo ' <small><a href="' . admin_url(  'plugins.php?show_form='.$i.'&amp;ctf_form_num='.$i.'&amp;page=si-contact-form/si-contact-form.php' ) . '">('. __('view', 'si-contact-form'). ')</a></small>';
        } else {
             echo ' | <a href="' . admin_url(  'plugins.php?ctf_form_num='.$i.'&amp;page=si-contact-form/si-contact-form.php' ) . '">'. sprintf(__('Form: %d', 'si-contact-form'),$i). '</a>';
        }
     }
  }
  ?>
  </h3>
  <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_multi_tip');"><?php _e('Multi-forms help', 'si-contact-form'); ?></a>
  <div style="text-align:left; display:none" id="si_contact_multi_tip">
  <?php _e('This multi-form feature allows you to have many different forms on your site. Each form has unique settings and shortcode. Select the form you want to edit using the links above, then edit the settings below for the form you selected. Be sure to use the correct shortcode to call the form.', 'si-contact-form') ?>
  </div>

<br />
<label for="si_contact_max_forms"><?php _e('Number of available Multi-forms', 'si-contact-form'); ?>:</label>
<input name="si_contact_max_forms" id="si_contact_max_forms" type="text" value="<?php echo absint($si_contact_gb['max_forms']);  ?>" size="3" />
<a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_multi_num_tip');"><?php _e('help', 'si-contact-form'); ?></a>
<div style="text-align:left; display:none" id="si_contact_multi_num_tip">
<?php _e('Use this setting to increase or decrease the number of available forms. The most forms you can add is 99. Caution: lowering this number will delete forms of a higher number than the number you set.', 'si-contact-form') ?>
</div>

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>


<div class="form-tab"><?php echo __('Form:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

        <label for="si_contact_welcome"><?php _e('Welcome introduction', 'si-contact-form'); ?>:</label><br />
        <textarea rows="6" cols="70" name="si_contact_welcome" id="si_contact_welcome"><?php echo $this->ctf_output_string($si_contact_opt['welcome']); ?></textarea>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_welcome_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_welcome_tip">
        <?php _e('This is printed before the contact form. HTML is allowed.', 'si-contact-form') ?>
        </div>

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('E-mail:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

<?php
// checks for properly configured E-mail To: addresses in options.
$ctf_contacts = array ();
$ctf_contacts_test = trim($si_contact_opt['email_to']);
$ctf_contacts_error = 0;
if(!preg_match("/,/", $ctf_contacts_test) ) {
    if($this->ctf_validate_email($ctf_contacts_test)) {
        // user1@example.com
       $ctf_contacts[] = array('CONTACT' => __('Webmaster', 'si-contact-form'),  'EMAIL' => $ctf_contacts_test );
    }
} else {
  $ctf_ct_arr = explode("\n",$ctf_contacts_test);
  if (is_array($ctf_ct_arr) ) {
    foreach($ctf_ct_arr as $line) {
        // echo '|'.$line.'|' ;
       list($key, $value) = explode(",",$line);
       $key   = trim($key);
       $value = trim($value);
       if ($key != '' && $value != '') {
          if(!preg_match("/;/", $value)) {
               // just one email here
               // Webmaster,user1@example.com
               if ($this->ctf_validate_email($value)) {
                  $ctf_contacts[] = array('CONTACT' => $key,  'EMAIL' => $value);
               } else {
                  $ctf_contacts_error = 1;
               }
          } else {
               // multiple emails here (additional ones will be Cc:)
               // Webmaster,user1@example.com;user2@example.com
               $multi_cc_arr = explode(";",$value);
               $multi_cc_string = '';
               foreach($multi_cc_arr as $multi_cc) {
                  if ($this->ctf_validate_email($multi_cc)) {
                     $multi_cc_string .= "$multi_cc,";
                  } else {
                     $ctf_contacts_error = 1;
                  }
               }
               if ($multi_cc_string != '') {  // multi cc emails
                  $ctf_contacts[] = array('CONTACT' => $key,  'EMAIL' => rtrim($multi_cc_string, ','));
               }
         }
      }
   } // end foreach
  } // end if (is_array($ctf_ct_arr) ) {
} // end else

//print_r($ctf_contacts);

?>
        <label for="si_contact_email_to"><?php _e('E-mail To', 'si-contact-form'); ?>:</label>
<?php
if (empty($ctf_contacts) || $ctf_contacts_error ) {
   echo '<span style="color:red;">'. __('ERROR: Misconfigured E-mail address in options.', 'si-contact-form').'</span>'."\n";
}

if ( !function_exists('mail') ) {
   echo '<br /><span style="color:red;">'. __('Warning: Your web host has the mail() function disabled. PHP cannot send email.', 'si-contact-form').'</span><br />'."\n";
  echo '<span style="color:red;">'. __('Have them fix it. Or you can install the "WP Mail SMTP" plugin and configure it to use SMTP.', 'si-contact-form').'</span><br />'."\n";
}
?>
        <br />
        <textarea rows="6" cols="70" name="si_contact_email_to" id="si_contact_email_to"><?php echo $this->ctf_output_string($si_contact_opt['email_to']);  ?></textarea>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_email_to_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_email_to_tip">
        <?php _e('E-mail address the messages are sent to (your email). Add as many contacts as you need, the drop down list on the contact form will be made automatically. Each contact has a name and an email address separated by a comma. Separate each contact by pressing enter. If you need to add more than one contact, follow this example:', 'si-contact-form'); ?><br />
        Webmaster,user1@example.com<br />
        Sales,user2@example.com<br /><br />

        <?php echo  __('Also, you can have multiple E-mails per contact, this is called a CC(Carbon Copy). Separate each CC with a semicolon. If you need to add more than one contact, each with a CC, follow this example:', 'si-contact-form'); ?><br />
        Webmaster,user1@example.com<br />
        Sales,user3@example.com;user4@example.com;user5@example.com
        </div>
        <br />
  <?php
   // Check for safe mode
    $safe_mode_is_on = ((boolean)@ini_get('safe_mode') === false) ? 0 : 1;
    if($safe_mode_is_on){
      echo '<br /><span style="color:red;">'. __('Warning: Your web host has PHP safe_mode turned on.', 'si-contact-form');
      echo '</span> ';
      echo __('PHP safe_mode can cause problems like sending mail failures and file permission errors.', 'si-contact-form')."<br />\n";
      echo __('PHP safe_mode is better turned off, relying on this feature might work, but is highly discouraged. Contact your web host for support.', 'si-contact-form')."<br /><br />\n";
    }

    // Check for older than PHP5
   if (phpversion() < 5) {
      echo '<br /><span style="color:red;">'. __('Warning: Your web host has not upgraded from PHP4 to PHP5.', 'si-contact-form');
      echo '</span> ';
      echo __('PHP4 was officially discontinued August 8, 2008 and is no longer considered safe.', 'si-contact-form')."<br />\n";
      echo __('PHP5 is faster, has more features, and is and safer. Using PHP4 might still work, but is highly discouraged. Contact your web host for support.', 'si-contact-form')."<br /><br />\n";
    }
  ?>

       <label for="si_contact_php_mailer_enable"><?php _e('Send E-mail function:', 'si-contact-form'); ?></label>
      <select id="si_contact_php_mailer_enable" name="si_contact_php_mailer_enable">
<?php

$selected = '';
foreach (array( 'wordpress' => esc_attr(__('WordPress', 'si-contact-form')),'geekmail' => esc_attr(__('geekMail', 'si-contact-form')),'php' => esc_attr(__('PHP', 'si-contact-form'))) as $k => $v) {
 if ($si_contact_opt['php_mailer_enable'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_php_mailer_enable_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_php_mailer_enable_tip">
        <?php _e('Emails are normally sent by the wordpress mail function. If you are not receiving email from your contact form. Try setting this to "geekMail" or "PHP", then test the form again. In some cases, this will resolve the problem.', 'si-contact-form'); ?>
        <?php _e('"geekMail" is a mail function that is included with this plugin.', 'si-contact-form'); ?>
        <?php _e('If your form still does not send any E-mail, be sure to also try setting the "E-mail From" setting below. Some web hosts do not allow PHP to send E-mail unless the "From:" E-mail address is on the same web domain.', 'si-contact-form'); ?>
        <?php _e('Note: attachments are only supported when using the "WordPress" or "geekMail" mail function.', 'si-contact-form'); ?>
       </div>
       <br />

        <label for="si_contact_email_from"><?php _e('E-mail From (optional)', 'si-contact-form'); ?>:</label>
<?php
if ( $si_contact_opt['email_from'] != '' ) {
    $from_fail = 0;
    if(!preg_match("/,/", $si_contact_opt['email_from'])) {
        // just one email here
        // user1@example.com
        if (!$this->ctf_validate_email($si_contact_opt['email_from'])) {
           $from_fail = 1;
        }
    } else {
        // name and email here
        // webmaster,user1@example.com
        list($key, $value) = explode(",",$si_contact_opt['email_from']);
        $key   = trim($key);
        $value = trim($value);
        if (!$this->ctf_validate_email($value)) {
           $from_fail = 1;
        }
   }
   if ($from_fail)  {
     echo '<span style="color:red;">'. __('ERROR: Misconfigured E-mail address in options.', 'si-contact-form').'</span><br />'."\n";
   }
}
?>
        <input name="si_contact_email_from" id="si_contact_email_from" type="text" value="<?php echo $si_contact_opt['email_from'];  ?>" size="50" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_email_from_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_email_from_tip">
        <?php _e('E-mail address the messages are sent from. Normally you can leave this blank. Some web hosts do not allow PHP to send E-mail unless the "From:" E-mail address is on the same web domain as your web site. And they require it to be a real address on that domain, or mail will NOT SEND! (They do this to help prevent spam.) If your contact form does not send any E-mail, then set this to a real E-mail address on the SAME domain as your web site as a possible fix.', 'si-contact-form'); ?>
        <?php _e('After setting the from address; if your form still does not send any E-mail, look above, and find this setting: "Send E-mail function:", try setting it to "geekMail" or "PHP", then test from the contact form again. In some cases, this will resolve the problem.', 'si-contact-form'); ?>
        <br />
        <?php _e('Enter just an email: user1@example.com', 'si-contact-form'); ?><br />
        <?php _e('Or enter name and email: webmaster,user1@example.com ', 'si-contact-form'); ?>
        </div>
        <br />

        <label for="si_contact_email_bcc"><?php _e('E-mail Bcc (optional)', 'si-contact-form'); ?>:</label>
<?php
if ( $si_contact_opt['email_bcc'] != ''){
    $bcc_fail = 0;
    if(!preg_match("/,/", $si_contact_opt['email_bcc'])) {
         // just one email here
         // user1@example.com
         if (!$this->ctf_validate_email($si_contact_opt['email_bcc'])) {
             $bcc_fail = 1;
         }
    } else {
         // multiple emails here
         // user1@example.com,user2@example.com
         $bcc_arr = explode(",",$si_contact_opt['email_bcc']);
         foreach($bcc_arr as $b_cc) {
             if (!$this->ctf_validate_email($b_cc)) {
                $bcc_fail = 1;
                break;
             }
         }
   }
   if ($bcc_fail)  {
      echo '<span style="color:red;">'. __('ERROR: Misconfigured E-mail address in options.', 'si-contact-form').'</span><br />'."\n";
   }
}
?>
        <input name="si_contact_email_bcc" id="si_contact_email_bcc" type="text" value="<?php echo $si_contact_opt['email_bcc'];  ?>" size="50" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_email_bcc_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_email_bcc_tip">
        <?php _e('This Bcc address is global, which means that if you have multi "E-mail To" contacts, any contact selected will send to this also.', 'si-contact-form'); ?>
        <?php _e('E-mail address(s) to receive Bcc (Blind Carbon Copy) messages. You can send to multiple or single, both methods are acceptable:', 'si-contact-form'); ?>
        <br />
        user1@example.com<br />
        user1@example.com,user2@example.com
        </div>
        <br />

        <label for="si_contact_email_subject"><?php _e('E-mail Subject Prefix', 'si-contact-form') ?>:</label><input name="si_contact_email_subject" id="si_contact_email_subject" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['email_subject']);  ?>" size="55" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_email_subject_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_email_subject_tip">
        <?php _e('This will become a prefix of the subject for the E-mail you receive.', 'si-contact-form'); ?>
        </div>
        <br />

        <label for="si_contact_email_subject_list"><?php _e('Optional E-mail Subject List', 'si-contact-form'); ?>:</label><br />
        <textarea rows="6" cols="70" name="si_contact_email_subject_list" id="si_contact_email_subject_list"><?php echo $this->ctf_output_string($si_contact_opt['email_subject_list']);  ?></textarea>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_email_subject_list_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_email_subject_list_tip">
        <?php _e('Optional E-mail subject drop down list. Add as many subject options as you need, the drop down list on the contact form will be made automatically. Separate each subject option by pressing enter. Follow this example:', 'si-contact-form'); ?><br />
        Newsletter Signup<br />
        Question<br />
        Comment
        </div>
        <br />

        <input name="si_contact_double_email" id="si_contact_double_email" type="checkbox" <?php if( $si_contact_opt['double_email'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_double_email"><?php _e('Enable double E-mail entry required on contact form.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_double_email_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_double_email_tip">
        <?php _e('Requires users to enter email address in two fields to help reduce mistakes.', 'si-contact-form') ?>
        </div>
        <br />

        <input name="si_contact_name_case_enable" id="si_contact_name_case_enable" type="checkbox" <?php if( $si_contact_opt['name_case_enable'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_name_case_enable"><?php _e('Enable upper case alphabet correction.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_name_case_enable_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_name_case_enable_tip">
        <?php _e('Automatically corrects form input using a function knowing about alphabet case (example: correct caps on McDonald, or correct USING ALL CAPS).', 'si-contact-form'); ?>
        <?php _e('Enable on English language only because it can cause accent character problems if enabled on other languages.', 'si-contact-form'); ?>
        </div>
        <br />

        <input name="si_contact_sender_info_enable" id="si_contact_sender_info_enable" type="checkbox" <?php if( $si_contact_opt['sender_info_enable'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_sender_info_enable"><?php _e('Enable sender information in E-mail footer.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_sender_info_enable_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_sender_info_enable_tip">
        <?php _e('You will receive in the E-mail, detailed information about the sender. Such as IP Address, date, time, and which web browser they used.', 'si-contact-form'); ?>
        </div>
        <br />

        <input name="si_contact_domain_protect" id="si_contact_domain_protect" type="checkbox" <?php if( $si_contact_opt['domain_protect'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_domain_protect"><?php _e('Enable Form Post security by requiring domain name match for', 'si-contact-form'); ?>
        <?php
        $uri = parse_url(get_option('home'));
        $blogdomain = preg_replace("/^www\./i",'',$uri['host']);
        echo " $blogdomain ";
        ?><?php _e('(recommended).', 'si-contact-form'); ?>
        </label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_domain_protect_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_domain_protect_tip">
        <?php _e('Prevents automated spam bots posting from off-site forms.', 'si-contact-form') ?>
        </div>
        <br />

        <input name="si_contact_email_check_dns" id="si_contact_email_check_dns" type="checkbox" <?php if( $si_contact_opt['email_check_dns'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_email_check_dns"><?php _e('Enable checking DNS records for the domain name when checking for a valid E-mail address.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_email_check_dns_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_email_check_dns_tip">
        <?php _e('Improves email address validation by checking that the domain of the email address actually has a valid DNS record.', 'si-contact-form') ?>
        </div>

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('Akismet:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

     <strong><?php _e('Akismet Spam Prevention:', 'si-contact-form'); ?></strong>

    <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_akismet_tip');"><?php _e('help', 'si-contact-form'); ?></a>
    <div style="text-align:left; display:none" id="si_contact_akismet_tip">
    <?php _e('Akismet is a WordPress spam prevention plugin. When Akismet is installed and active, all Fast Secure Contact Form posts will be checked with Akismet to help prevent spam.', 'si-contact-form') ?>
    </div>
    <br />

<?php
if( $si_contact_opt['akismet_disable'] == 'false' ) {
 if (function_exists('akismet_verify_key')) {
    if (!isset($_POST['si_contact_akismet_check'])){
       echo '<span style="background-color:#99CC99;">'. __('Akismet is installed.', 'si-contact-form'). '</span>';
    }
    if (isset($_POST['si_contact_akismet_check'])){;
      $key_status = 'failed';
	  $key = get_option('wordpress_api_key');
		if ( empty( $key ) ) {
			$key_status = 'empty';
		} else {
			$key_status = akismet_verify_key( $key );
		}
		if ( $key_status == 'valid' ) {
            ?><div id="message" class="updated"><strong><?php echo __('Akismet is enabled and the key is valid. All Fast Secure Contact Form posts will be checked with Akismet to help prevent spam', 'si-contact-form'); ?></strong></div><?php
            echo '<span class="updated">' . __('Akismet is installed and the key is valid. All Fast Secure Contact Form posts will be checked with Akismet to help prevent spam.', 'si-contact-form'). '</strong></span>';
		} else if ( $key_status == 'invalid' ) {
			?><div id="message" class="error"><strong><?php echo __('Akismet plugin is enabled but key needs to be activated', 'si-contact-form'); ?></strong></div><?php
             echo '<span class="error">'. __('Akismet plugin is installed but key needs to be activated.', 'si-contact-form'). '</span>';
		} else if ( !empty($key) && $key_status == 'failed' ) {
			?><div id="message" class="error"><strong><?php echo __('Akismet plugin is enabled but key failed to verify', 'si-contact-form'); ?></strong></div><?php
             echo '<span class="error">'.__('Akismet plugin is installed but key failed to verify.', 'si-contact-form'). '</span>';
		}
    }
?>
<br />
  <input name="si_contact_akismet_check" id="si_contact_akismet_check" type="checkbox" value="1" />
  <label for="si_contact_akismet_check"><?php _e('Check this and click "Update Options" to determine if Akismet key is active.', 'si-contact-form'); ?></label>
<br />
<?php echo '<a href="'.admin_url(  "plugins.php?page=akismet-key-config" ).'">' . __('Configure Akismet', 'si-contact-form').'</a>'; ?>
<?php
  }else{
     echo '<span class="error">'.__('Akismet plugin is not installed or is deactivated.', 'si-contact-form'). '</span>';
  }
} else {
    echo '<span class="error">'.__('Akismet is turned off for this form.', 'si-contact-form'). '</span>';
}
 if( $si_contact_opt['akismet_disable'] == 'false' ) {
?>
<br />
  <label for="si_contact_akismet_send_anyway"><?php _e('What should happen if Akismet determines the message is spam?', 'si-contact-form'); ?></label>
   <select id="si_contact_akismet_send_anyway" name="si_contact_akismet_send_anyway">
<?php
$akismet_send_anyway_array = array(
'false' => esc_attr(__('Block spam messages', 'si-contact-form')),
'true' => esc_attr(__('Tag as spam and send anyway', 'si-contact-form')),
);
$selected = '';
foreach ($akismet_send_anyway_array as $k => $v) {
 if ($si_contact_opt['akismet_send_anyway'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
<a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_akismet_send_anyway_tip');"><?php _e('help', 'si-contact-form'); ?></a>
    <div style="text-align:left; display:none" id="si_contact_akismet_send_anyway_tip">
    <?php _e('If you select "block spam messages". If Akismet determines the message is spam: An error will display "Invalid Input - Spam?" and the form will not send.', 'si-contact-form'); ?>
    <?php echo ' '; _e('If you select "tag as spam and send anyway". If Akismet determines the message is spam: The message will send and the subject wil begin with "Akismet: Spam". This way you can have Akismet on and be sure not to miss a message.', 'si-contact-form'); ?>
    </div>
<?php
} else {
    echo '<input name="si_contact_akismet_send_anyway" type="hidden" value="'. $si_contact_opt['akismet_send_anyway'].'" />';
}
?>
<br />
  <input name="si_contact_akismet_disable" id="si_contact_akismet_disable" type="checkbox" <?php if( $si_contact_opt['akismet_disable'] == 'true' ) echo 'checked="checked"'; ?> />
  <label for="si_contact_akismet_disable"><?php _e('Turn off Akismet for this form.', 'si-contact-form'); ?></label>

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('CAPTCHA:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

        <input name="si_contact_captcha_enable" id="si_contact_captcha_enable" type="checkbox" <?php if ( $si_contact_opt['captcha_enable'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_captcha_enable"><?php _e('Enable CAPTCHA (recommended).', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_captcha_enable_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_captcha_enable_tip">
        <?php _e('Prevents automated spam bots by requiring that the user pass a CAPTCHA test before posting. You can disable CAPTCHA if you prefer, because the form also uses Akismet to prevent spam when Akismet plugin is installed with the key activated.', 'si-contact-form') ?>
        </div>
        <br />

        <input name="si_contact_captcha_disable_session" id="si_contact_captcha_disable_session" type="checkbox" <?php if ( $si_contact_gb['captcha_disable_session'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_captcha_disable_session"><?php _e('Use CAPTCHA without PHP session.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_captcha_disable_session_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_captcha_disable_session_tip">
        <?php _e('Sometimes the CAPTCHA code never validates because of a server problem with PHP session handling. If the CAPTCHA code never validates and does not work, you can enable this setting to use files for session.', 'si-contact-form'); ?>
        </div>
        <br />
        <?php
         if ( $si_contact_gb['captcha_disable_session'] == 'true' ){
            $check_this_dir = WP_PLUGIN_DIR . '/si-contact-form/captcha-secureimage/captcha-temp';
           if(is_writable($check_this_dir)) {
				//echo '<span style="color: green">OK - Writable</span> ' . substr(sprintf('%o', fileperms($check_this_dir)), -4);
           } else if(!file_exists($check_this_dir)) {
              echo '<span style="color: red;">';
              echo __('There is a problem with the directory', 'si-contact-form');
              echo ' /captcha-secureimage/captcha-temp/. ';
	          echo __('The directory is not found, a <a href="http://codex.wordpress.org/Changing_File_Permissions" target="_blank">permissions</a> problem may have prevented this directory from being created.', 'si-contact-form');
              echo ' ';
              echo __('Fixing the actual problem is recommended, but you can uncheck this setting on the contact form options page: "Use CAPTCHA without PHP session" and the captcha will work this way just fine (as long as PHP sessions are working).', 'si-contact-form');
              echo '</span><br />';
           } else {
             echo '<span style="color: red;">';
             echo __('There is a problem with the directory', 'si-contact-form') .' /captcha-secureimage/captcha-temp/. ';
             echo __('The directory Unwritable (<a href="http://codex.wordpress.org/Changing_File_Permissions" target="_blank">fix permissions</a>)', 'si-contact-form').'. ';
             echo __('Permissions are: ', 'si-contact-form');
             echo ' ';
             echo substr(sprintf('%o', fileperms($check_this_dir)), -4);
             echo ' ';
             echo __('Fixing this may require assigning 0755 permissions or higher (e.g. 0777 on some hosts. Try 0755 first, because 0777 is sometimes too much and will not work.)', 'si-contact-form');
             echo ' ';
             echo __('Fixing the actual problem is recommended, but you can uncheck this setting on the contact form options page: "Use CAPTCHA without PHP session" and the captcha will work this way just fine (as long as PHP sessions are working).', 'si-contact-form');
             echo '</span><br />';
          }
         }

        ?>

        <label for="si_contact_captcha_difficulty"><?php _e('CAPTCHA difficulty level:', 'si-contact-form'); ?></label>
      <select id="si_contact_captcha_difficulty" name="si_contact_captcha_difficulty">
<?php
$captcha_difficulty_array = array(
'low' => esc_attr(__('Low', 'si-contact-form')),
'medium' => esc_attr(__('Medium', 'si-contact-form')),
'high' => esc_attr(__('High', 'si-contact-form')),
);
$selected = '';
foreach ($captcha_difficulty_array as $k => $v) {
 if ($si_contact_opt['captcha_difficulty'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_captcha_difficulty_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_captcha_difficulty_tip">
        <?php _e('Changes level of distortion of the CAPTCHA image text.', 'si-contact-form') ?>
        </div>
        <br />

        <input name="si_contact_captcha_small" id="si_contact_captcha_small" type="checkbox" <?php if ( $si_contact_opt['captcha_small'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_captcha_small"><?php _e('Enable smaller size CAPTCHA image.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_captcha_small_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_captcha_small_tip">
        <?php _e('Makes the CAPTCHA image smaller.', 'si-contact-form') ?>
        </div>
        <br />

        <input name="si_contact_captcha_no_trans" id="si_contact_captcha_no_trans" type="checkbox" <?php if ( $si_contact_opt['captcha_no_trans'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_captcha_no_trans"><?php _e('Disable CAPTCHA transparent text (only if captcha text is missing on the image, try this fix).', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_captcha_no_trans_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_captcha_no_trans_tip">
        <?php _e('Sometimes fixes missing text on the CAPTCHA image. If this does not fix missing text, your PHP server is not compatible with the CAPTCHA functions. You can disable CAPTCHA or have your web server fixed.', 'si-contact-form') ?>
        </div>
        <br />

        <input name="si_contact_enable_audio" id="si_contact_enable_audio" type="checkbox" <?php if ( $si_contact_opt['enable_audio'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_enable_audio"><?php _e('Enable Audio for the CAPTCHA.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_enable_audio_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_enable_audio_tip">
        <?php _e('Enables an icon so the user can listen to an audio sound of the CAPTCHA.', 'si-contact-form') ?>
        </div>
        <br />

        <input name="si_contact_enable_audio_flash" id="si_contact_enable_audio_flash" type="checkbox" <?php if ( $si_contact_opt['enable_audio_flash'] == 'true') echo ' checked="checked" '; ?> />
        <label for="si_contact_enable_audio_flash"><?php _e('Enable Flash Audio for the CAPTCHA.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_enable_audio_flash_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_enable_audio_flash_tip">
        <?php _e('Enables a flash object so the user can listen to an audio sound of the CAPTCHA without having to download the sound file.', 'si-contact-form') ?>
        </div>
        <br />

        <input name="si_contact_captcha_perm" id="si_contact_captcha_perm" type="checkbox" <?php if( $si_contact_opt['captcha_perm'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_captcha_perm"><?php _e('Hide CAPTCHA for', 'si-contact-form'); ?>
        <strong><?php _e('registered', 'si-contact-form'); ?></strong> <?php __('users who can', 'si-contact-form'); ?>:</label>
        <?php $this->si_contact_captcha_perm_dropdown('si_contact_captcha_perm_level', $si_contact_opt['captcha_perm_level']);  ?><br />

        <a href="<?php echo "$captcha_url_cf/test/index.php"; ?>" target="_new"><?php _e('Test if your PHP installation will support the CAPTCHA', 'si-contact-form'); ?></a>

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('Redirect:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

        <input name="si_contact_redirect_enable" id="si_contact_redirect_enable" type="checkbox" <?php if( $si_contact_opt['redirect_enable'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_redirect_enable"><?php _e('Enable redirect after the message sends', 'si-contact-form'); ?>.</label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_redirect_enable_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_redirect_enable_tip">
        <?php _e('If enabled: After a user sends a message, the web browser will display "message sent" for x seconds, then redirect to the redirect URL. This can be used to redirect to the blog home page, or a custom "Thank You" page.', 'si-contact-form'); ?>
        </div>
        <br />

        <label for="si_contact_redirect_seconds"><?php _e('Redirect delay in seconds', 'si-contact-form'); ?>:</label>
        <input name="si_contact_redirect_seconds" id="si_contact_redirect_seconds" type="text" value="<?php echo absint($si_contact_opt['redirect_seconds']);  ?>" size="3" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_redirect_seconds_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_redirect_seconds_tip">
        <?php _e('How many seconds the web browser will display "message sent" before redirecting to the redirect URL. Values of 0-60 are allowed.', 'si-contact-form'); ?>
        </div>
        <br />

        <label for="si_contact_redirect_url"><?php _e('Redirect URL', 'si-contact-form'); ?>:</label><input name="si_contact_redirect_url" id="si_contact_redirect_url" type="text" value="<?php echo $si_contact_opt['redirect_url'];  ?>" size="50" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_redirect_url_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_redirect_url_tip">
        <?php _e('The form will redirect to this URL after success. This can be used to redirect to the blog home page, or a custom "Thank You" page.', 'si-contact-form'); ?>
        <?php _e('Use FULL URL including http:// for best results.', 'si-contact-form'); ?>
        </div>
</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<?php if( $si_contact_gb['adv_opt_enable'] == 'false' ) {
    // advanced options not always on
?>
<h3><a style="cursor:pointer;" title="<?php _e('Click for Advanced Options', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_advanced');"><?php _e('Click for Advanced Options', 'si-contact-form'); ?></a> <?php echo sprintf(__('(form %d)', 'si-contact-form'),$form_id); ?></h3>
<div style="text-align:left; display:none" id="si_contact_advanced">
<?php } ?>

<div class="form-tab"><?php echo __('Form:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

   <input name="si_contact_adv_opt_enable" id="si_contact_adv_opt_enable" type="checkbox" <?php if( $si_contact_gb['adv_opt_enable'] == 'true' ) echo 'checked="checked"'; ?> />
   <label for="si_contact_adv_opt_enable"><?php _e('Advanced Options - Stay Open', 'si-contact-form'); ?></label>
   <a style="cursor:pointer;" title="<?php echo __('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('adv_opt_enable_tip');">
   <?php echo __('help', 'si-contact-form'); ?></a>
   <div style="text-align:left; display:none" id="adv_opt_enable_tip">
   <?php echo __('Enable to make the Advance Options always stay open.', 'si-contact-form'); ?>
   </div>
<br />
<br />

<strong><?php echo __('Standard Fields:', 'si-contact-form'); ?></strong><br />
       <a style="cursor:pointer;" title="<?php echo __('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('stand_fields_tip');">
       <?php echo __('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="stand_fields_tip">
       <?php echo __('The standard fields can be set to be required or not, or even be disabled.', 'si-contact-form'); ?>
      </div>
 <br />

       <input name="si_contact_auto_fill_enable" id="si_contact_auto_fill_enable" type="checkbox" <?php if( $si_contact_opt['auto_fill_enable'] == 'true' ) echo 'checked="checked"'; ?> />
       <label for="si_contact_auto_fill_enable"><?php _e('Enable auto form fill', 'si-contact-form'); ?>.</label>
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_auto_fill_enable_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_auto_fill_enable_tip">
       <?php _e('Auto form fill email address and name (username) on the contact form for logged in users who are not administrators.', 'si-contact-form'); ?>
       </div>
       <br />

      <label for="si_contact_name_type"><?php _e('Name field:', 'si-contact-form'); ?></label>
      <select id="si_contact_name_type" name="si_contact_name_type">
<?php
$name_type_array = array(
'not_available' => esc_attr(__('Not Available', 'si-contact-form')),
'not_required' => esc_attr(__('Not Required', 'si-contact-form')),
'required' => esc_attr(__('Required', 'si-contact-form')),
);
$selected = '';
foreach ($name_type_array as $k => $v) {
 if ($si_contact_opt['name_type'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>

      <label for="si_contact_name_format"><?php _e('Name field format:', 'si-contact-form'); ?></label>
      <select id="si_contact_name_format" name="si_contact_name_format">
<?php
$name_format_array = array(
'name' => esc_attr(__('Name', 'si-contact-form')),
'first_last' => esc_attr(__('First Name, Last Name', 'si-contact-form')),
'first_middle_i_last' => esc_attr(__('First Name, Middle Initial, Last Name', 'si-contact-form')),
'first_middle_last' => esc_attr(__('First Name, Middle Name, Last Name', 'si-contact-form')),
);
$selected = '';
foreach ($name_format_array as $k => $v) {
 if ($si_contact_opt['name_format'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_name_format_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_name_format_tip">
       <?php _e('Select how the name field is formatted on the form.', 'si-contact-form'); ?>
       </div>
<br />

      <label for="si_contact_email_type"><?php _e('E-mail field:', 'si-contact-form'); ?></label>
      <select id="si_contact_email_type" name="si_contact_email_type">
<?php
$selected = '';
foreach ($name_type_array as $k => $v) {
 if ($si_contact_opt['email_type'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
<br />

      <label for="si_contact_subject_type"><?php _e('Subject field:', 'si-contact-form'); ?></label>
      <select id="si_contact_subject_type" name="si_contact_subject_type">
<?php
$selected = '';
foreach ($name_type_array as $k => $v) {
 if ($si_contact_opt['subject_type'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
<br />


      <label for="si_contact_message_type"><?php _e('Message field:', 'si-contact-form'); ?></label>
      <select id="si_contact_message_type" name="si_contact_message_type">
<?php
$selected = '';
foreach ($name_type_array as $k => $v) {
 if ($si_contact_opt['message_type'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
<br />
<br />

<strong><?php _e('Extra Fields:', 'si-contact-form'); ?></strong><br />
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_extra_fields_tip');"><?php _e('Click here to see instructions for extra fields.', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_extra_fields_tip">
       <br />
<strong><?php _e('Instructions for how to use Extra Fields:', 'si-contact-form'); ?></strong>
       <blockquote>
      <?php _e('You can use extra contact form fields for phone number, company name, etc. To enable an extra field, just enter a label. Then check if you want the field to be required or not. To disable, empty the label.', 'si-contact-form'); ?>
<br /><strong><?php _e('Text and Textarea fields:', 'si-contact-form'); ?></strong><br />
       <?php _e('The text field is for single line text entry. The textarea field is for multiple line text entry.', 'si-contact-form'); ?>
<br /><strong><?php _e('Select, Radio, and Checkbox extra fields:', 'si-contact-form'); ?></strong><br />
       <?php _e('When using select, checkbox, or radio field types; first enter the label and a comma. Include the options separating with a semicolon like this example: Color:,Red;Green;Blue.', 'si-contact-form'); ?>
       <?php _e('To make "Green" the default selection: set default to 2. (Default is for checkbox, radio, and select types).', 'si-contact-form'); ?>
       <?php _e('You can also use a multiple checkbox like this example: Pizza Toppings:,olives;mushrooms;cheese;ham;tomatoes. Now multiple items can be checked for the "Pizza Toppings" label.', 'si-contact-form'); ?>
       <?php _e('By default radio and checkboxes are displayed vertical. Here is how to make them display horizontal: add the tag {inline} before the label, like this: {inline}Pizza Toppings:,olives;mushrooms;cheese;ham;tomatoes.', 'si-contact-form'); ?>
<br /><strong><?php _e('Attachment:', 'si-contact-form'); ?></strong><br />
       <?php _e('The attachment is used to allow users to attach a file upload from the form. You can add multiple attachments. The attachment is sent with your email. Attachments are deleted from the server after the email is sent.', 'si-contact-form'); ?>
<br /><strong><?php _e('Date field:', 'si-contact-form'); ?></strong><br />
       <?php _e('The date is used to allow a date field with a calendar pop-up. The date field ensures that a date entry is in a standard format every time.', 'si-contact-form'); ?>
<br /><strong><?php _e('Fieldset:', 'si-contact-form'); ?></strong><br />
       <?php _e('The fieldset(box-open) is used to draw a box around related form elements. The fieldset label is used for a (legend) title of the group.', 'si-contact-form'); ?>
       <br />
       <?php _e('The fieldset(box-close) is used to close a box around related form elements. A label is not required for this type. If you do not close a fieldset box, it will close automatically when you add another fieldset box.', 'si-contact-form'); ?>
 <br /><strong><?php _e('Notes:', 'si-contact-form'); ?></strong><br />
       <?php _e('Use the optional notes/help to print some notes or instructions before a form field. This is for the form display only, not E-mail. HTML is allowed.', 'si-contact-form'); ?>
       </blockquote>
</div>

 <br />

 <label for="si_contact_max_fields"><?php _e('Number of available extra fields', 'si-contact-form'); ?>:</label>
 <input name="si_contact_max_fields" id="si_contact_max_fields" type="text" value="<?php echo absint($si_contact_gb['max_fields']);  ?>" size="3" />

 <br />

      <?php
$field_type_array = array(
'text' => esc_attr(__('text', 'si-contact-form')),
'textarea' => esc_attr(__('textarea', 'si-contact-form')),
'checkbox' => esc_attr(__('checkbox', 'si-contact-form')),
'radio' => esc_attr(__('radio', 'si-contact-form')),
'select' => esc_attr(__('select', 'si-contact-form')),
'attachment' => esc_attr(__('attachment', 'si-contact-form')),
'date' => esc_attr(__('date', 'si-contact-form')),
'fieldset' => esc_attr(__('fieldset(box-open)', 'si-contact-form')),
'fieldset-close' => esc_attr(__('fieldset(box-close)', 'si-contact-form')),
);
      // optional extra fields
      for ($i = 1; $i <= $si_contact_gb['max_fields']; $i++) {
      ?>
       <label for="<?php echo 'si_contact_ex_field'.$i.'_notes' ?>"><?php printf(__('Optional notes/help for form field %d:', 'si-contact-form'),$i); ?></label>
       <input name="<?php echo 'si_contact_ex_field'.$i.'_notes' ?>" id="<?php echo 'si_contact_ex_field'.$i.'_notes' ?>" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['ex_field'.$i.'_notes']);  ?>" size="100" />
       <br />

       <label for="<?php echo 'si_contact_ex_field'.$i.'_label' ?>"><?php printf(__('Label for extra form field %d:', 'si-contact-form'),$i); ?></label>
       <input name="<?php echo 'si_contact_ex_field'.$i.'_label' ?>" id="<?php echo 'si_contact_ex_field'.$i.'_label' ?>" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['ex_field'.$i.'_label']);  ?>" size="50" />

       <label for="<?php echo 'si_contact_ex_field'.$i.'_type' ?>"><?php _e('Field type:', 'si-contact-form'); ?></label>
       <select id="<?php echo 'si_contact_ex_field'.$i.'_type' ?>" name="<?php echo 'si_contact_ex_field'.$i.'_type' ?>">
<?php
$selected = '';
foreach ($field_type_array as $k => $v) {
 if ($si_contact_opt['ex_field'.$i.'_type'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>

      <label for="<?php echo 'si_contact_ex_field'.$i.'_default' ?>"><?php printf(__('Default:', 'si-contact-form'),$i); ?></label>
       <input name="<?php echo 'si_contact_ex_field'.$i.'_default' ?>" id="<?php echo 'si_contact_ex_field'.$i.'_default' ?>" type="text" value="<?php echo $this->ctf_output_string(isset($si_contact_opt['ex_field'.$i.'_default']) ? $si_contact_opt['ex_field'.$i.'_default'] : 0);  ?>" size="2" />

       <input name="<?php echo 'si_contact_ex_field'.$i.'_req' ?>" id="<?php echo 'si_contact_ex_field'.$i.'_req' ?>" type="checkbox" <?php if( $si_contact_opt['ex_field'.$i.'_req'] == 'true' ) echo 'checked="checked"'; ?> />
       <label for="<?php echo 'si_contact_ex_field'.$i.'_req' ?>"><?php _e('Required field', 'si-contact-form'); ?></label>
       <br />

      <?php
      } // end foreach
      ?>
<br />
      <input name="si_contact_ex_fields_after_msg" id="si_contact_ex_fields_after_msg" type="checkbox" <?php if( $si_contact_opt['ex_fields_after_msg'] == 'true' ) echo 'checked="checked"'; ?> />
      <label for="si_contact_ex_fields_after_msg"><?php _e('Move extra fields to after the Message field.', 'si-contact-form'); ?></label>
      <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_ex_fields_after_msg_tip');"><?php _e('help', 'si-contact-form'); ?></a>
      <div style="text-align:left; display:none" id="si_contact_ex_fields_after_msg_tip">
      <?php _e('Normally the extra fields are inserted into the form between the E-mail address and the Subject fields. Enabling this setting will move the extra fields to after the Message field.', 'si-contact-form'); ?>
      </div>
<br />

      <label for="si_contact_date_format"><?php _e('Date field - Date format:', 'si-contact-form'); ?></label>
      <select id="si_contact_date_format" name="si_contact_date_format">
<?php
$selected = '';
$cal_date_array = array(
'mm/dd/yyyy' => esc_attr(__('mm/dd/yyyy', 'si-contact-form')),
'dd/mm/yyyy' => esc_attr(__('dd/mm/yyyy', 'si-contact-form')),
'mm-dd-yyyy' => esc_attr(__('mm-dd-yyyy', 'si-contact-form')),
'dd-mm-yyyy' => esc_attr(__('dd-mm-yyyy', 'si-contact-form')),
'mm.dd.yyyy' => esc_attr(__('mm.dd.yyyy', 'si-contact-form')),
'dd.mm.yyyy' => esc_attr(__('dd.mm.yyyy', 'si-contact-form')),
'yyyy/mm/dd' => esc_attr(__('yyyy/mm/dd', 'si-contact-form')),
'yyyy-mm-dd' => esc_attr(__('yyyy-mm-dd', 'si-contact-form')),
'yyyy.mm.dd' => esc_attr(__('yyyy.mm.dd', 'si-contact-form')),
);
foreach ($cal_date_array as $k => $v) {
 if ($si_contact_opt['date_format'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_date_format_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_date_format_tip">
       <?php _e('Use to set the date format for the date field.', 'si-contact-form'); ?>
       </div>
<br />

       <label for="si_contact_cal_start_day"><?php _e('Date field - Calendar Start Day of the Week', 'si-contact-form'); ?>:</label><input name="si_contact_cal_start_day" id="si_contact_cal_start_day" type="text" value="<?php echo absint($si_contact_opt['cal_start_day']);  ?>" size="3" />
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_cal_start_day_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_cal_start_day_tip">
       <?php _e('Use to set the day the week the date field calendar will start on: 0(Sun) to 6(Sat).', 'si-contact-form'); ?>
       </div>
<br />

        <label for="si_contact_attach_types"><?php _e('Attached files acceptable types', 'si-contact-form'); ?>:</label><input name="si_contact_attach_types" id="si_contact_attach_types" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['attach_types']);  ?>" size="60" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_attach_types_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_attach_types_tip">
        <?php _e('Set the acceptable file types for the file attachment feature. Any file type not on this list will be rejected.', 'si-contact-form'); ?>
        <?php _e('Separate each file type with a comma character. example:', 'si-contact-form'); ?>
        doc,pdf,txt,gif,jpg,jpeg,png
        </div>
<br />

        <label for="si_contact_attach_size"><?php _e('Attached files maximum size allowed', 'si-contact-form'); ?>:</label><input name="si_contact_attach_size" id="si_contact_attach_size" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['attach_size']);  ?>" size="30" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_attach_size_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_attach_size_tip">
        <?php _e('Set the acceptable maximum file size for the file attachment feature.', 'si-contact-form'); ?><br />
        <?php _e('example: 1mb equals one Megabyte, 1kb equals one Kilobyte', 'si-contact-form');
        $max_upload = (int)(ini_get('upload_max_filesize'));
        $max_post = (int)(ini_get('post_max_size'));
        $memory_limit = (int)(ini_get('memory_limit'));
        $upload_mb = min($max_upload, $max_post, $memory_limit);
        ?><br />
        <?php _e('Note: Maximum size is limited to available server resources and various PHP settings. Very few servers will accept more than 2mb. Sizes under 1mb will usually have best results. examples:', 'si-contact-form'); ?>
        500kb, 800kb, 1mb, 1.5mb, 2mb
        <?php _e('Note: If you set the value higher than your server can handle, users will have problems uploading big files. The form can time out and may not even show an error.', 'si-contact-form'); ?>
        <b><?php _e('Your server will not allow uploading files larger than than:', 'si-contact-form');  echo " $upload_mb"; ?>mb</b>
        </div>
<br />

        <input name="si_contact_textarea_html_allow" id="si_contact_textarea_html_allow" type="checkbox" <?php if( $si_contact_opt['textarea_html_allow'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_textarea_html_allow"><?php _e('Enable users to send HTML code in the textarea extra field types.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_textarea_html_allow_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_textarea_html_allow_tip">
        <?php _e('Enable only if you want users to be able to send HTML code in the textarea extra field types. This is disabled by default for better security. HTML code is only needed for sharing embedded video links, PHP code samples, etc.', 'si-contact-form'); ?>
        </div>
<br />

        <input name="si_contact_enable_credit_link" id="si_contact_enable_credit_link" type="checkbox" <?php if ( $si_contact_opt['enable_credit_link'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_enable_credit_link"><?php _e('Enable plugin credit link:', 'si-contact-form') ?></label> <?php echo __('Powered by', 'si-contact-form'). ' <a href="http://wordpress.org/extend/plugins/si-contact-form/" target="_new">'.__('Fast Secure Contact Form', 'si-contact-form'); ?></a>

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('Autoresponder:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>

<fieldset>

        <input name="si_contact_auto_respond_enable" id="si_contact_auto_respond_enable" type="checkbox" <?php if( $si_contact_opt['auto_respond_enable'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_auto_respond_enable"><?php _e('Enable autoresponder E-mail message.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_auto_respond_enable_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_auto_respond_enable_tip">
        <?php _e('Enable when you want the form to automatically answer with an autoresponder E-mail message.', 'si-contact-form'); ?>
        </div>
<br />

        <label for="si_contact_auto_respond_from_name"><?php _e('Autoresponder E-mail From name', 'si-contact-form'); ?>:</label><input name="si_contact_auto_respond_from_name" id="si_contact_auto_respond_from_name" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['auto_respond_from_name']);  ?>" size="60" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_auto_respond_from_name_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_auto_respond_from_name_tip">
        <?php _e('This sets the name in the from field when the autoresponder sends E-mail.', 'si-contact-form'); ?>
        </div>
<br />

        <label for="si_contact_auto_respond_reply_to"><?php _e('Autoresponder E-mail "Reply To" address', 'si-contact-form'); ?>:</label><input name="si_contact_auto_respond_reply_to" id="si_contact_auto_respond_reply_to" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['auto_respond_reply_to']);  ?>" size="60" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_auto_respond_reply_to_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_auto_respond_reply_to_tip">
        <?php _e('This sets the "reply to" E-mail address when the autoresponder sends E-mail.', 'si-contact-form'); ?>
        </div>
<br />

        <label for="si_contact_auto_respond_subject"><?php _e('Autoresponder E-mail subject', 'si-contact-form'); ?>:</label><input name="si_contact_auto_respond_subject" id="si_contact_auto_respond_subject" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['auto_respond_subject']);  ?>" size="60" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_auto_respond_subject_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_auto_respond_subject_tip">
        <?php _e('Type your autoresponder E-mail subject here, then enable it with the setting above.', 'si-contact-form'); ?>
        </div>
<br />

        <label for="si_contact_auto_respond_message"><?php _e('Autoresponder E-mail message', 'si-contact-form'); ?>:</label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_auto_respond_message_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_auto_respond_message_tip">
        <?php _e('Type your autoresponder E-mail message here, then enable it with the setting above.', 'si-contact-form'); ?>
        </div><br />
        <textarea rows="3" cols="50" name="si_contact_auto_respond_message" id="si_contact_auto_respond_message"><?php echo $this->ctf_output_string($si_contact_opt['auto_respond_message']);  ?></textarea>
<br />

        <input name="si_contact_auto_respond_html" id="si_contact_auto_respond_html" type="checkbox" <?php if( $si_contact_opt['auto_respond_html'] == 'true' ) echo 'checked="checked"'; ?> />
        <label for="si_contact_auto_respond_html"><?php _e('Enable using HTML in autoresponder E-mail message.', 'si-contact-form'); ?></label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_auto_respond_html_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_auto_respond_html_tip">
        <?php _e('Enable when you want to use HTML in the autoresponder E-mail message.', 'si-contact-form'); echo ' ';?>
        <?php _e('Then you can use an HTML message. example:', 'si-contact-form'); ?><br />
&lt;html&gt;&lt;body&gt;<br />
&lt;h1&gt;<?php _e('Hello World!', 'si-contact-form'); ?>&lt;/h1&gt;<br />
&lt;/body&gt;&lt;/html&gt;
        </div>

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('Style:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

        <input name="si_contact_reset_styles" id="si_contact_reset_styles" type="checkbox" />
        <label for="si_contact_reset_styles"><strong><?php _e('Reset the styles to default.', 'si-contact-form') ?></strong></label><br />

        <input name="si_contact_border_enable" id="si_contact_border_enable" type="checkbox" <?php if ( $si_contact_opt['border_enable'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_border_enable"><?php _e('Enable border on contact form', 'si-contact-form') ?>.</label>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_border_enable_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_border_enable_tip">
       <?php _e('Enable to draw a fieldset box around all the form elements. The default label for the fieldset is "Contact Form:", but you can change it in the "Fields:" section below.', 'si-contact-form'); ?>
       </div>
<br />
<br />

        <strong><?php _e('Modifiable CSS Style Feature:', 'si-contact-form'); ?></strong>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_css_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_css_tip">
        <?php _e('Use to adjust the font colors or other styling of the contact form.', 'si-contact-form'); ?><br />
        <?php _e('You can use inline css, or add a class property to be used by your own stylsheet.', 'si-contact-form'); ?><br />
        <?php _e('Acceptable Examples:', 'si-contact-form'); ?><br />
        text-align:left; color:#000000; background-color:#CCCCCC;<br />
        style="text-align:left; color:#000000; background-color:#CCCCCC;"<br />
        class="input"
        </div>
<br />

        <label for="si_contact_form_style"><?php _e('CSS style for form DIV on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_form_style" id="si_contact_form_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['form_style']);  ?>" size="60" />
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_form_style_tip');"><?php _e('help', 'si-contact-form'); ?></a>
        <div style="text-align:left; display:none" id="si_contact_form_style_tip">
        <?php _e('Use to adjust the style of the contact form border (if border is enabled).', 'si-contact-form'); ?>
        </div>
<br />

        <label for="si_contact_border_style"><?php _e('CSS style for border on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_border_style" id="si_contact_border_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['border_style']);  ?>" size="60" /><br />
        <label for="si_contact_required_style"><?php _e('CSS style for required field text on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_required_style" id="si_contact_required_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['required_style']);  ?>" size="60" /><br />
        <label for="si_contact_title_style"><?php _e('CSS style for form input titles on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_title_style" id="si_contact_title_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_style']);  ?>" size="60" /><br />
        <label for="si_contact_field_style"><?php _e('CSS style for form input fields on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_field_style" id="si_contact_field_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['field_style']);  ?>" size="60" /><br />
        <label for="si_contact_field_div_style"><?php _e('CSS style for form input fields DIV on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_field_div_style" id="si_contact_field_div_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['field_div_style']);  ?>" size="60" /><br />
        <label for="si_contact_error_style"><?php _e('CSS style for form input errors on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_error_style" id="si_contact_error_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_style']);  ?>" size="60" /><br />
        <label for="si_contact_select_style"><?php _e('CSS style for contact drop down select on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_select_style" id="si_contact_select_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['select_style']);  ?>" size="60" /><br />
        <label for="si_contact_captcha_div_style_sm"><?php _e('CSS style for Small CAPTCHA DIV on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_captcha_div_style_sm" id="si_contact_captcha_div_style_sm" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['captcha_div_style_sm']);  ?>" size="60" /><br />
        <label for="si_contact_captcha_div_style_m"><?php _e('CSS style for CAPTCHA DIV on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_captcha_div_style_m" id="si_contact_captcha_div_style_m" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['captcha_div_style_m']);  ?>" size="60" /><br />
        <label for="si_contact_submit_div_style"><?php _e('CSS style for Submit DIV on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_submit_div_style" id="si_contact_submit_div_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['submit_div_style']);  ?>" size="60" /><br />
        <label for="si_contact_button_style"><?php _e('CSS style for Submit button on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_button_style" id="si_contact_button_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['button_style']);  ?>" size="60" /><br />
        <label for="si_contact_powered_by_style"><?php _e('CSS style for "Powered by" message on the contact form', 'si-contact-form'); ?>:</label><input name="si_contact_powered_by_style" id="si_contact_powered_by_style" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['powered_by_style']);  ?>" size="60" />
<br />

       <label for="si_contact_field_size"><?php _e('Input Text Field Size', 'si-contact-form'); ?>:</label><input name="si_contact_field_size" id="si_contact_field_size" type="text" value="<?php echo absint($si_contact_opt['field_size']);  ?>" size="3" />
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_field_size_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_field_size_tip">
       <?php _e('Use to adjust the size of the contact form text input fields.', 'si-contact-form'); ?>
       </div>
<br />

       <label for="si_contact_captcha_field_size"><?php _e('Input CAPTCHA Field Size', 'si-contact-form'); ?>:</label><input name="si_contact_captcha_field_size" id="si_contact_captcha_field_size" type="text" value="<?php echo absint($si_contact_opt['captcha_field_size']);  ?>" size="3" />
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_captcha_field_size_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_captcha_field_size_tip">
       <?php _e('Use to adjust the size of the contact form CAPTCHA input field.', 'si-contact-form'); ?>
       </div>
<br />

       <label for="si_contact_text_cols"><?php _e('Input Textarea Field Cols', 'si-contact-form'); ?>:</label><input name="si_contact_text_cols" id="si_contact_text_cols" type="text" value="<?php echo absint($si_contact_opt['text_cols']);  ?>" size="3" />
       <label for="si_contact_text_rows"><?php _e('Rows', 'si-contact-form'); ?>:</label><input name="si_contact_text_rows" id="si_contact_text_rows" type="text" value="<?php echo absint($si_contact_opt['text_rows']);  ?>" size="3" />
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_text_rows_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_text_rows_tip">
       <?php _e('Use to adjust the size of the contact form message textarea.', 'si-contact-form'); ?>
       </div>
<br />

       <input name="si_contact_aria_required" id="si_contact_aria_required" type="checkbox" <?php if( $si_contact_opt['aria_required'] == 'true' ) echo 'checked="checked"'; ?> />
       <label for="si_contact_aria_required"><?php _e('Enable aria-required tags for screen readers', 'si-contact-form'); ?>.</label>
       <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_aria_required_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_aria_required_tip">
       <?php _e('aria-required is a form input WAI ARIA tag. Screen readers use it to determine which fields are required. Enabling this is good for accessability, but will cause the HTML to fail the W3C Validation (there is no attribute "aria-required"). WAI ARIA attributes are soon to be accepted by the HTML validator, so you can safely ignore the validation error it will cause.', 'si-contact-form'); ?>
       </div>

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('Fields:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>

<strong><?php _e('Change field labels:', 'si-contact-form'); ?></strong>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_text_fields_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_text_fields_tip">
       <?php _e('Some people wanted to change the labels for the contact form. These fields can be filled in to override the standard labels.', 'si-contact-form'); ?>
       </div>
<br />

        <input name="si_contact_req_field_indicator_enable" id="si_contact_req_field_indicator_enable" type="checkbox" <?php if ( $si_contact_opt['req_field_indicator_enable'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_req_field_indicator_enable"><?php _e('Enable required field indicators on contact form', 'si-contact-form') ?>.</label>
<br />
        <label for="si_contact_req_field_indicator"><?php _e('Required field indicator:', 'si-contact-form'); ?></label><input name="si_contact_req_field_indicator" id="si_contact_req_field_indicator" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['req_field_indicator']);  ?>" size="20" /><br />

        <input name="si_contact_req_field_label_enable" id="si_contact_req_field_label_enable" type="checkbox" <?php if ( $si_contact_opt['req_field_label_enable'] == 'true' ) echo ' checked="checked" '; ?> />
        <label for="si_contact_req_field_label_enable"><?php _e('Enable required field label on contact form:', 'si-contact-form') ?></label> <?php echo ($si_contact_opt['tooltip_required'] != '') ? $si_contact_opt['req_field_indicator'] .$si_contact_opt['tooltip_required'] : $si_contact_opt['req_field_indicator'] . __('(denotes required field)', 'si-contact-form'); ?><br />


         <label for="si_contact_title_border"><?php _e('Contact Form', 'si-contact-form'); ?>:</label><input name="si_contact_title_border" id="si_contact_title_border" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_border']);  ?>" size="50" /><br />
         <label for="si_contact_title_dept"><?php _e('Department to Contact', 'si-contact-form'); ?>:</label><input name="si_contact_title_dept" id="si_contact_title_dept" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_dept']);  ?>" size="50" /><br />
         <label for="si_contact_title_select"><?php _e('Select', 'si-contact-form'); ?>:</label><input name="si_contact_title_select" id="si_contact_title_select" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_select']);  ?>" size="50" /><br />
         <label for="si_contact_title_name"><?php _e('Name', 'si-contact-form'); ?>:</label><input name="si_contact_title_name" id="si_contact_title_name" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_name']);  ?>" size="50" /><br />
         <label for="si_contact_title_email"><?php _e('E-Mail Address', 'si-contact-form'); ?>:</label><input name="si_contact_title_email" id="si_contact_title_email" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_email']);  ?>" size="50" /><br />
         <label for="si_contact_title_email2"><?php _e('E-Mail Address again', 'si-contact-form'); ?>:</label><input name="si_contact_title_email2" id="si_contact_title_email2" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_email2']);  ?>" size="50" /><br />
         <label for="si_contact_title_email2"><?php _e('Please enter your E-mail Address a second time.', 'si-contact-form'); ?></label><input name="si_contact_title_email2_help" id="si_contact_title_email2_help" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_email2_help']);  ?>" size="50" /><br />
         <label for="si_contact_title_subj"><?php _e('Subject', 'si-contact-form'); ?>:</label><input name="si_contact_title_subj" id="si_contact_title_subj" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_subj']);  ?>" size="50" /><br />
         <label for="si_contact_title_mess"><?php _e('Message', 'si-contact-form'); ?>:</label><input name="si_contact_title_mess" id="si_contact_title_mess" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_mess']);  ?>" size="50" /><br />
         <label for="si_contact_title_capt"><?php _e('CAPTCHA Code', 'si-contact-form'); ?>:</label><input name="si_contact_title_capt" id="si_contact_title_capt" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_capt']);  ?>" size="50" /><br />
         <label for="si_contact_title_submit"><?php _e('Submit', 'si-contact-form'); ?></label><input name="si_contact_title_submit" id="si_contact_title_submit" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['title_submit']);  ?>" size="50" /><br />
         <label for="si_contact_text_message_sent"><?php _e('Your message has been sent, thank you.', 'si-contact-form'); ?></label><input name="si_contact_text_message_sent" id="si_contact_text_message_sent" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['text_message_sent']);  ?>" size="50" /><br />

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('Tooltips:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>
<strong><?php _e('Change tooltips labels:', 'si-contact-form'); ?></strong>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_text_tools_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_text_tools_tip">
       <?php _e('Some people wanted to change the labels for the contact form. These fields can be filled in to override the standard labels.', 'si-contact-form'); ?>
       </div>
<br />

        <label for="si_contact_tooltip_required"><?php _e('(denotes required field)', 'si-contact-form'); ?></label><input name="si_contact_tooltip_required" id="si_contact_tooltip_required" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['tooltip_required']);  ?>" size="50" /><br />
        <label for="si_contact_tooltip_captcha"><?php _e('CAPTCHA Image', 'si-contact-form'); ?></label><input name="si_contact_tooltip_captcha" id="si_contact_tooltip_captcha" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['tooltip_captcha']);  ?>" size="50" /><br />
        <label for="si_contact_tooltip_audio"><?php _e('CAPTCHA Audio', 'si-contact-form'); ?></label><input name="si_contact_tooltip_audio" id="si_contact_tooltip_audio" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['tooltip_audio']);  ?>" size="50" /><br />
        <label for="si_contact_tooltip_refresh"><?php _e('Refresh Image', 'si-contact-form'); ?></label><input name="si_contact_tooltip_refresh" id="si_contact_tooltip_refresh" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['tooltip_refresh']);  ?>" size="50" />

</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>

<div class="form-tab"><?php echo __('Errors:', 'si-contact-form') .' '. sprintf(__('(form %d)', 'si-contact-form'),$form_id);?></div>
<div class="clear"></div>
<fieldset>
<strong><?php _e('Change error labels:', 'si-contact-form'); ?></strong>
        <a style="cursor:pointer;" title="<?php _e('Click for Help!', 'si-contact-form'); ?>" onclick="toggleVisibility('si_contact_error_fields_tip');"><?php _e('help', 'si-contact-form'); ?></a>
       <div style="text-align:left; display:none" id="si_contact_error_fields_tip">
       <?php _e('Some people wanted to change the error messages for the contact form. These fields can be filled in to override the standard included error messages.', 'si-contact-form'); ?>
       </div>
       <br />
         <label for="si_contact_error_contact_select"><?php _e('Selecting a contact is required.', 'si-contact-form'); ?></label><input name="si_contact_error_contact_select" id="si_contact_error_contact_select" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_contact_select']);  ?>" size="50" /><br />
         <label for="si_contact_error_name"><?php _e('Your name is required.', 'si-contact-form'); ?></label><input name="si_contact_error_name" id="si_contact_error_name" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_name']);  ?>" size="50" /><br />
         <label for="si_contact_error_email"><?php _e('A proper e-mail address is required.', 'si-contact-form'); ?></label><input name="si_contact_error_email" id="si_contact_error_email" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_email']);  ?>" size="50" /><br />
         <label for="si_contact_error_email2"><?php _e('The two e-mail addresses did not match, please enter again.', 'si-contact-form'); ?></label><input name="si_contact_error_email2" id="si_contact_error_email2" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_email2']);  ?>" size="50" /><br />
         <label for="si_contact_error_field"><?php _e('This field is required.', 'si-contact-form'); ?></label><input name="si_contact_error_field" id="si_contact_error_field" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_field']);  ?>" size="50" /><br />
         <label for="si_contact_error_subject"><?php _e('Subject text is required.', 'si-contact-form'); ?></label><input name="si_contact_error_subject" id="si_contact_error_subject" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_subject']);  ?>" size="50" /><br />
         <label for="si_contact_error_message"><?php _e('Message text is required.', 'si-contact-form'); ?></label><input name="si_contact_error_message" id="si_contact_error_message" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_message']);  ?>" size="50" /><br />
         <label for="si_contact_error_input"><?php _e('Contact Form has Invalid Input', 'si-contact-form'); ?></label><input name="si_contact_error_input" id="si_contact_error_input" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_input']);  ?>" size="50" /><br />
         <label for="si_contact_error_captcha_blank"><?php _e('Please complete the CAPTCHA.', 'si-contact-form'); ?></label><input name="si_contact_error_captcha_blank" id="si_contact_error_captcha_blank" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_captcha_blank']);  ?>" size="50" /><br />
         <label for="si_contact_error_captcha_wrong"><?php _e('That CAPTCHA was incorrect.', 'si-contact-form'); ?></label><input name="si_contact_error_captcha_wrong" id="si_contact_error_captcha_wrong" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_captcha_wrong']);  ?>" size="50" /><br />
         <label for="si_contact_error_correct"><?php _e('Please make corrections below and try again.', 'si-contact-form'); ?></label><input name="si_contact_error_correct" id="si_contact_error_correct" type="text" value="<?php echo $this->ctf_output_string($si_contact_opt['error_correct']);  ?>" size="50" />
</fieldset>

    <p class="submit">
      <input type="submit" name="submit" value="<?php echo esc_attr( __('Update Options', 'si-contact-form')); ?> &raquo;" />
    </p>
<?php if( $si_contact_gb['adv_opt_enable'] == 'false' ) {
    // advanced options not always on
?>
   </div> <!-- end Click for Advanced  -->
<?php } ?>
</form>

<form action="<?php echo admin_url( "plugins.php?ctf_form_num=$form_num&amp;page=si-contact-form/si-contact-form.php" ); ?>" method="post">
<?php wp_nonce_field('si-contact-form-email_test'); ?>
<fieldset class="options" style="border:1px solid black; padding:10px;">
<legend><?php _e('Send a Test E-mail', 'si-contact-form'); ?></legend>
<?php _e('If you are not receiving email form your form, try this test because it can display troubleshooting information.', 'si-contact-form'); ?><br />
<?php _e('There are settings you can use to try to fix email delivery problems, see this FAQ for help:', 'si-contact-form'); ?>
 <a href="http://wordpress.org/extend/plugins/si-contact-form/faq/" target="_blank"><?php _e('FAQ', 'si-contact-form'); ?></a><br />
<?php _e('Type an email address here and then click Send Test to generate a test email.', 'si-contact-form'); ?>
<?php
if ( !function_exists('mail') ) {
  echo '<br /><span style="color:red;">'. __('Warning: Your web host has the mail() function disabled. PHP cannot send email.', 'si-contact-form').'</span><br />'."\n";
  echo '<span style="color:red;">'. __('Have them fix it. Or you can install the "WP Mail SMTP" plugin and configure it to use SMTP.', 'si-contact-form').'</span>'."\n";
}
?>
<br />
<label for="si_contact_to"><?php _e('To:', 'si-contact-form'); ?></label>
<input type="text" name="si_contact_to" id="si_contact_to" value="" size="40" class="code" />
<p style="padding:0px;" class="submit">
<input type="submit" name="ctf_action" value="<?php _e('Send Test', 'si-contact-form'); ?>" />
</p>
</fieldset>
</form>

<br />

<form id="ctf_backup_settings" action="<?php echo admin_url( "plugins.php?ctf_form_num=$form_num&amp;page=si-contact-form/si-contact-form.php" ); ?>" method="post">
<?php wp_nonce_field('si-contact-form-backup_settings'); ?>
<fieldset class="options" style="border:1px solid black; padding:10px;">

<legend><?php _e('Backup Settings', 'si-contact-form'); ?></legend>
<?php _e('This tool can save a backup of your contact form settings.', 'si-contact-form'); ?><br />
<?php _e('Use to transfer one, or all, of your forms from one site to another. Or just make a backup to save.', 'si-contact-form'); ?><br />
<label for="si_contact_backup_type"><?php _e('Select a form to backup:', 'si-contact-form'); ?></label>

<select id="si_contact_backup_type" name="si_contact_backup_type">
<?php
$backup_type_array = array(
'all' => esc_attr(__('All Forms', 'si-contact-form')),
);
$backup_type_array["1"] = esc_attr(sprintf(__('Form: %d', 'si-contact-form'),1));
// multi-forms > 1
for ($i = 2; $i <= $si_contact_gb['max_forms']; $i++) {
$backup_type_array[$i] = esc_attr(sprintf(__('Form: %d', 'si-contact-form'),$i));
}
$selected = '';
foreach ($backup_type_array as $k => $v) {
 if (isset($_POST['si_contact_backup_type']) && $_POST['si_contact_backup_type'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>

<p style="padding:0px;" class="submit">
<input type="submit" name="ctf_action" value="<?php _e('Backup Settings', 'si-contact-form'); ?>" />
</p>

</fieldset>
</form>

<br />

<form enctype="multipart/form-data" id="ctf_restore_settings" action="<?php echo admin_url( "plugins.php?ctf_form_num=$form_num&amp;page=si-contact-form/si-contact-form.php" ); ?>" method="post">
<?php wp_nonce_field('si-contact-form-restore_settings'); ?>
<fieldset class="options" style="border:1px solid black; padding:10px;">

<legend><?php _e('Restore Settings', 'si-contact-form'); ?></legend>
<?php _e('This tool can restore a backup of your contact form settings. If you have previously made a backup, you can restore one or all your forms. It is a good idea to backup all forms before you restore any. Changes are permanent!', 'si-contact-form'); ?><br />
<label for="si_contact_restore_backup_type"><?php _e('Select a form to restore:', 'si-contact-form'); ?></label>

<select id="si_contact_restore_backup_type" name="si_contact_backup_type">
<?php
$backup_type_array = array(
'all' => esc_attr(__('All Forms', 'si-contact-form')),
);
$backup_type_array["1"] = esc_attr(sprintf(__('Form: %d', 'si-contact-form'),1));
// multi-forms > 1
for ($i = 2; $i <= $si_contact_gb['max_forms']; $i++) {
$backup_type_array[$i] = esc_attr(sprintf(__('Form: %d', 'si-contact-form'),$i));
}
$selected = '';
foreach ($backup_type_array as $k => $v) {
 if (isset($_POST['si_contact_backup_type']) && $_POST['si_contact_backup_type'] == "$k")  $selected = ' selected="selected"';
 echo '<option value="'.$k.'"'.$selected.'>'.$v.'</option>'."\n";
 $selected = '';
}
?>
</select>
<br />

<label for="si_contact_backup_file"><?php _e('Upload Backup File:', 'si-contact-form'); ?></label>
<input style="text-align:left; margin:0;" type="file" id="si_contact_backup_file" name="si_contact_backup_file" value=""  size="20" />

<p style="padding:0px;" class="submit">
<input type="submit" name="ctf_action" onclick="alert('<?php _e('Are you sure you want to permanently make this change?', 'si-contact-form'); ?>')" value="<?php _e('Restore Settings', 'si-contact-form'); ?>" />
</p>

</fieldset>
</form>

<p><strong><?php _e('More WordPress plugins by Mike Challis:', 'si-contact-form') ?></strong></p>
<ul>
<li><a href="http://www.FastSecureContactForm.com/" target="_blank"><?php _e('Fast Secure Contact Form', 'si-contact-form'); ?></a></li>
<li><a href="http://wordpress.org/extend/plugins/si-captcha-for-wordpress/" target="_blank"><?php _e('SI CAPTCHA Anti-Spam', 'si-contact-form'); ?></a></li>
<li><a href="http://wordpress.org/extend/plugins/visitor-maps/" target="_blank"><?php _e('Visitor Maps and Who\'s Online', 'si-contact-form'); ?></a></li>

</ul>
</div>
</div><!-- end div main -->

<?php
 } // if show form
?>